/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.application.jsp;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import net.sourceforge.myfaces.webapp.webxml.ServletMapping;
import net.sourceforge.myfaces.webapp.webxml.WebXml;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.DefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryConfig;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.TilesUtil;

public class JspTilesViewHandlerImpl
extends ViewHandler {
    private ViewHandler _viewHandler;
    private static final Log log = LogFactory.getLog((Class)(class$net$sourceforge$myfaces$application$jsp$JspTilesViewHandlerImpl == null ? (class$net$sourceforge$myfaces$application$jsp$JspTilesViewHandlerImpl = JspTilesViewHandlerImpl.class$("net.sourceforge.myfaces.application.jsp.JspTilesViewHandlerImpl")) : class$net$sourceforge$myfaces$application$jsp$JspTilesViewHandlerImpl));
    private static final String TILES_EXTENSION = ".tiles";
    private static final String TILES_DEF_ATTR = "tiles-definitions";
    private DefinitionsFactory _definitionsFactory;
    static /* synthetic */ Class class$net$sourceforge$myfaces$application$jsp$JspTilesViewHandlerImpl;

    public JspTilesViewHandlerImpl(ViewHandler viewHandler) {
        this._viewHandler = viewHandler;
    }

    private DefinitionsFactory getDefinitionsFactory() {
        if (this._definitionsFactory == null) {
            ExternalContext context;
            String tilesDefinitions;
            if (log.isDebugEnabled()) {
                log.debug((Object)"JspTilesViewHandlerImpl init");
            }
            if ((tilesDefinitions = (context = FacesContext.getCurrentInstance().getExternalContext()).getInitParameter(TILES_DEF_ATTR)) == null) {
                log.fatal((Object)"No Tiles definition found. Specify Definition files by adding tiles-definitions param in your web.xml");
                return null;
            }
            DefinitionsFactoryConfig factoryConfig = new DefinitionsFactoryConfig();
            factoryConfig.setDefinitionConfigFiles(tilesDefinitions);
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Reading tiles definitions");
                }
                this._definitionsFactory = TilesUtil.createDefinitionsFactory((ServletContext)((ServletContext)context.getContext()), (DefinitionsFactoryConfig)factoryConfig);
            }
            catch (DefinitionsFactoryException e) {
                log.fatal((Object)"Error reading tiles definitions", (Throwable)e);
                return null;
            }
        }
        return this._definitionsFactory;
    }

    public void renderView(FacesContext facesContext, UIViewRoot viewToRender) throws IOException, FacesException {
        String tilesId;
        int idx;
        if (viewToRender == null) {
            log.fatal((Object)"viewToRender must not be null");
            throw new NullPointerException("viewToRender must not be null");
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        String viewId = facesContext.getViewRoot().getViewId();
        ServletMapping servletMapping = JspTilesViewHandlerImpl.getServletMapping(externalContext);
        if (servletMapping.isExtensionMapping()) {
            String suffix;
            String defaultSuffix = externalContext.getInitParameter("javax.faces.DEFAULT_SUFFIX");
            String string = suffix = defaultSuffix != null ? defaultSuffix : ".jsp";
            if (!viewId.endsWith(suffix)) {
                int dot = viewId.lastIndexOf(46);
                if (dot == -1) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Current viewId has no extension, appending default suffix " + suffix));
                    }
                    viewId = viewId + suffix;
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Replacing extension of current viewId by suffix " + suffix));
                    }
                    viewId = viewId.substring(0, dot) + suffix;
                }
                facesContext.getViewRoot().setViewId(viewId);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Dispatching to " + viewId));
        }
        tilesId = (idx = (tilesId = viewId).indexOf(".")) > 0 ? tilesId.substring(0, tilesId.indexOf(".")) + TILES_EXTENSION : tilesId + TILES_EXTENSION;
        ServletRequest request = (ServletRequest)externalContext.getRequest();
        ServletContext servletContext = (ServletContext)externalContext.getContext();
        ComponentDefinition definition = null;
        try {
            definition = this.getDefinitionsFactory().getDefinition(tilesId, request, servletContext);
            if (definition == null) {
                log.error((Object)("could not find tiles-definition with name " + tilesId));
                throw new NullPointerException("could not find tiles-definition with name " + tilesId);
            }
        }
        catch (DefinitionsFactoryException e) {
            throw new FacesException((Throwable)e);
        }
        ComponentContext tileContext = ComponentContext.getContext((ServletRequest)request);
        if (tileContext == null) {
            tileContext = new ComponentContext(definition.getAttributes());
            ComponentContext.setContext((ComponentContext)tileContext, (ServletRequest)request);
        } else {
            tileContext.addMissing(definition.getAttributes());
        }
        viewId = definition.getPage();
        externalContext.dispatch(viewId);
    }

    private static ServletMapping getServletMapping(ExternalContext externalContext) {
        String servletPath = externalContext.getRequestServletPath();
        String requestPathInfo = externalContext.getRequestPathInfo();
        WebXml webxml = WebXml.getWebXml(externalContext);
        List mappings = webxml.getFacesServletMappings();
        boolean isExtensionMapping = requestPathInfo == null;
        int size = mappings.size();
        for (int i = 0; i < size; ++i) {
            String extension;
            ServletMapping servletMapping = (ServletMapping)mappings.get(i);
            if (servletMapping.isExtensionMapping() != isExtensionMapping) continue;
            String urlpattern = servletMapping.getUrlPattern();
            if (!(isExtensionMapping ? servletPath.endsWith(extension = urlpattern.substring(1, urlpattern.length())) : servletPath.equals(urlpattern = urlpattern.substring(0, urlpattern.length() - 2)))) continue;
            return servletMapping;
        }
        log.error((Object)("could not find pathMapping for servletPath = " + servletPath + " requestPathInfo = " + requestPathInfo));
        throw new IllegalArgumentException("could not find pathMapping for servletPath = " + servletPath + " requestPathInfo = " + requestPathInfo);
    }

    public Locale calculateLocale(FacesContext context) {
        return this._viewHandler.calculateLocale(context);
    }

    public String calculateRenderKitId(FacesContext context) {
        return this._viewHandler.calculateRenderKitId(context);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        return this._viewHandler.createView(context, viewId);
    }

    public String getActionURL(FacesContext context, String viewId) {
        return this._viewHandler.getActionURL(context, viewId);
    }

    public String getResourceURL(FacesContext context, String path) {
        return this._viewHandler.getResourceURL(context, path);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        return this._viewHandler.restoreView(context, viewId);
    }

    public void writeState(FacesContext context) throws IOException {
        this._viewHandler.writeState(context);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

