/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.renderkit.html;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import net.sourceforge.myfaces.renderkit.MyfacesResponseStateManager;
import net.sourceforge.myfaces.util.MyFacesObjectInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlResponseStateManager
extends MyfacesResponseStateManager {
    private static final Log log = LogFactory.getLog((Class)(class$net$sourceforge$myfaces$renderkit$html$HtmlResponseStateManager == null ? (class$net$sourceforge$myfaces$renderkit$html$HtmlResponseStateManager = HtmlResponseStateManager.class$("net.sourceforge.myfaces.renderkit.html.HtmlResponseStateManager")) : class$net$sourceforge$myfaces$renderkit$html$HtmlResponseStateManager));
    private static final String TREE_PARAM = "jsf_tree";
    private static final String STATE_PARAM = "jsf_state";
    private static final String VIEWID_PARAM = "jsf_viewid";
    private static final String BASE64_TREE_PARAM = "jsf_tree_64";
    private static final String BASE64_STATE_PARAM = "jsf_state_64";
    private static final String ZIP_CHARSET = "ISO-8859-1";
    static /* synthetic */ Class class$net$sourceforge$myfaces$renderkit$html$HtmlResponseStateManager;

    public void writeState(FacesContext facescontext, StateManager.SerializedView serializedview) throws IOException {
        ResponseWriter responseWriter = facescontext.getResponseWriter();
        Object treeStruct = serializedview.getStructure();
        Object compStates = serializedview.getState();
        if (treeStruct != null) {
            if (treeStruct instanceof String) {
                responseWriter.startElement("input", null);
                responseWriter.writeAttribute("type", (Object)"hidden", null);
                responseWriter.writeAttribute("name", (Object)TREE_PARAM, null);
                responseWriter.writeAttribute("value", treeStruct, null);
                responseWriter.endElement("input");
            } else {
                responseWriter.startElement("input", null);
                responseWriter.writeAttribute("type", (Object)"hidden", null);
                responseWriter.writeAttribute("name", (Object)BASE64_TREE_PARAM, null);
                responseWriter.writeAttribute("value", (Object)this.encode64(treeStruct), null);
                responseWriter.endElement("input");
            }
        } else {
            log.error((Object)"No tree structure to be saved in client response!");
        }
        if (compStates != null) {
            if (compStates instanceof String) {
                responseWriter.startElement("input", null);
                responseWriter.writeAttribute("type", (Object)"hidden", null);
                responseWriter.writeAttribute("name", (Object)STATE_PARAM, null);
                responseWriter.writeAttribute("value", compStates, null);
                responseWriter.endElement("input");
            } else {
                responseWriter.startElement("input", null);
                responseWriter.writeAttribute("type", (Object)"hidden", null);
                responseWriter.writeAttribute("name", (Object)BASE64_STATE_PARAM, null);
                responseWriter.writeAttribute("value", (Object)this.encode64(compStates), null);
                responseWriter.endElement("input");
            }
        } else {
            log.error((Object)"No component states to be saved in client response!");
        }
        responseWriter.startElement("input", null);
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        responseWriter.writeAttribute("name", (Object)VIEWID_PARAM, null);
        responseWriter.writeAttribute("value", (Object)facescontext.getViewRoot().getViewId(), null);
        responseWriter.endElement("input");
    }

    public void writeStateAsUrlParams(FacesContext facescontext, StateManager.SerializedView serializedview) throws IOException {
        ResponseWriter responseWriter = facescontext.getResponseWriter();
        Object treeStruct = serializedview.getStructure();
        Object compStates = serializedview.getState();
        if (treeStruct != null) {
            if (treeStruct instanceof String) {
                this.writeStateParam(responseWriter, TREE_PARAM, (String)treeStruct);
            } else {
                this.writeStateParam(responseWriter, BASE64_TREE_PARAM, this.encode64(treeStruct));
            }
        } else {
            log.error((Object)"No tree structure to be saved in client response!");
        }
        if (compStates != null) {
            if (treeStruct != null) {
                responseWriter.write(38);
            }
            if (compStates instanceof String) {
                this.writeStateParam(responseWriter, STATE_PARAM, (String)compStates);
            } else {
                this.writeStateParam(responseWriter, BASE64_STATE_PARAM, this.encode64(compStates));
            }
        } else {
            log.error((Object)"No component states to be saved in client response!");
        }
        if (treeStruct != null || compStates != null) {
            responseWriter.write(38);
        }
        this.writeStateParam(responseWriter, VIEWID_PARAM, facescontext.getViewRoot().getViewId());
    }

    private String encode64(Object obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream zos = new GZIPOutputStream(baos);
            ObjectOutputStream oos = new ObjectOutputStream(zos);
            oos.writeObject(obj);
            oos.close();
            ((OutputStream)zos).close();
            baos.close();
            Base64 base64Codec = new Base64();
            return new String(base64Codec.encode(baos.toByteArray()), ZIP_CHARSET);
        }
        catch (IOException e) {
            log.fatal((Object)"Cannot encode Object with Base64", (Throwable)e);
            throw new FacesException((Throwable)e);
        }
    }

    public Object getTreeStructureToRestore(FacesContext facescontext, String viewId) {
        Map reqParamMap = facescontext.getExternalContext().getRequestParameterMap();
        Object param = reqParamMap.get(VIEWID_PARAM);
        if (param == null || !param.equals(viewId)) {
            return null;
        }
        param = reqParamMap.get(TREE_PARAM);
        if (param != null) {
            return param;
        }
        param = reqParamMap.get(BASE64_TREE_PARAM);
        if (param != null) {
            return this.decode64((String)param);
        }
        return null;
    }

    public Object getComponentStateToRestore(FacesContext facescontext) {
        Map reqParamMap = facescontext.getExternalContext().getRequestParameterMap();
        Object param = reqParamMap.get(STATE_PARAM);
        if (param != null) {
            return param;
        }
        param = reqParamMap.get(BASE64_STATE_PARAM);
        if (param != null) {
            return this.decode64((String)param);
        }
        return null;
    }

    private Object decode64(String s) {
        try {
            Base64 base64Codec = new Base64();
            ByteArrayInputStream decodedStream = new ByteArrayInputStream(base64Codec.decode(s.getBytes(ZIP_CHARSET)));
            GZIPInputStream unzippedStream = new GZIPInputStream(decodedStream);
            MyFacesObjectInputStream ois = new MyFacesObjectInputStream(unzippedStream);
            Object obj = ois.readObject();
            ois.close();
            ((InputStream)unzippedStream).close();
            decodedStream.close();
            return obj;
        }
        catch (IOException e) {
            log.fatal((Object)"Cannot decode Object from Base64 String", (Throwable)e);
            throw new FacesException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.fatal((Object)"Cannot decode Object from Base64 String", (Throwable)e);
            throw new FacesException((Throwable)e);
        }
    }

    private void writeStateParam(ResponseWriter writer, String name, String value) throws IOException {
        writer.write(name);
        writer.write(61);
        writer.write(URLEncoder.encode(value, writer.getCharacterEncoding()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

