/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import net.sourceforge.myfaces.renderkit.RendererUtils;
import net.sourceforge.myfaces.renderkit.html.HTML;
import net.sourceforge.myfaces.renderkit.html.HtmlRenderer;
import net.sourceforge.myfaces.renderkit.html.HtmlRendererUtils;
import net.sourceforge.myfaces.util.ArrayUtils;
import net.sourceforge.myfaces.util.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlTableRendererBase
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog((Class)(class$net$sourceforge$myfaces$renderkit$html$HtmlTableRendererBase == null ? (class$net$sourceforge$myfaces$renderkit$html$HtmlTableRendererBase = HtmlTableRendererBase.class$("net.sourceforge.myfaces.renderkit.html.HtmlTableRendererBase")) : class$net$sourceforge$myfaces$renderkit$html$HtmlTableRendererBase));
    static /* synthetic */ Class class$net$sourceforge$myfaces$renderkit$html$HtmlTableRendererBase;
    static /* synthetic */ Class class$javax$faces$component$UIData;

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = HtmlTableRendererBase.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData);
        ResponseWriter writer = facesContext.getResponseWriter();
        this.beforeTable(facesContext, (UIData)uiComponent);
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("table", uiComponent);
        writer.writeAttribute("id", (Object)uiComponent.getClientId(facesContext), null);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
        this.renderFacet(facesContext, writer, (UIData)uiComponent, true);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        int last;
        String columnClasses;
        String rowClasses;
        RendererUtils.checkParamValidity(facesContext, component, class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = HtmlTableRendererBase.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData);
        UIData uiData = (UIData)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tbody", component);
        if (component instanceof HtmlDataTable) {
            rowClasses = ((HtmlDataTable)component).getRowClasses();
            columnClasses = ((HtmlDataTable)component).getColumnClasses();
        } else {
            rowClasses = (String)component.getAttributes().get("rowClasses");
            columnClasses = (String)component.getAttributes().get("columnClasses");
        }
        Styles styles = new Styles(rowClasses, columnClasses);
        int first = uiData.getFirst();
        int rows = uiData.getRows();
        int rowCount = uiData.getRowCount();
        if (rows <= 0) {
            rows = rowCount - first;
        }
        if ((last = first + rows) > rowCount) {
            last = rowCount;
        }
        for (int i = first; i < last; ++i) {
            uiData.setRowIndex(i);
            if (!uiData.isRowAvailable()) {
                log.error((Object)("Row is not available. Rowindex = " + i));
                return;
            }
            this.beforeRow(facesContext, uiData);
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("tr", component);
            if (styles.hasRowStyle()) {
                String rowStyle = styles.getRowStyle(i);
                writer.writeAttribute("class", (Object)rowStyle, null);
            }
            List children = component.getChildren();
            int size = component.getChildCount();
            for (int j = 0; j < size; ++j) {
                UIComponent child = (UIComponent)children.get(j);
                if (!(child instanceof UIColumn) || !((UIColumn)child).isRendered()) continue;
                writer.startElement("td", component);
                if (styles.hasColumnStyle()) {
                    String columnStyle = styles.getColumnStyle(j);
                    writer.writeAttribute("class", (Object)columnStyle, null);
                }
                RendererUtils.renderChild(facesContext, child);
                writer.endElement("td");
            }
            writer.endElement("tr");
            this.afterRow(facesContext, uiData);
        }
        writer.endElement("tbody");
    }

    protected void beforeTable(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void beforeRow(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void afterRow(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void afterTable(FacesContext facesContext, UIData uiData) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = HtmlTableRendererBase.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData);
        ResponseWriter writer = facesContext.getResponseWriter();
        this.renderFacet(facesContext, writer, (UIData)uiComponent, false);
        writer.endElement("table");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        this.afterTable(facesContext, (UIData)uiComponent);
    }

    private void renderFacet(FacesContext facesContext, ResponseWriter writer, UIData uiData, boolean header) throws IOException {
        UIComponent facet;
        int colspan = 0;
        boolean hasColumnFacet = false;
        Iterator it = uiData.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent uiComponent = (UIComponent)it.next();
            if (!(uiComponent instanceof UIColumn) || !((UIColumn)uiComponent).isRendered()) continue;
            ++colspan;
            if (hasColumnFacet) continue;
            hasColumnFacet = header ? ((UIColumn)uiComponent).getHeader() != null : ((UIColumn)uiComponent).getFooter() != null;
        }
        UIComponent uIComponent = facet = header ? uiData.getHeader() : uiData.getFooter();
        if (facet != null || hasColumnFacet) {
            String elemName = header ? "thead" : "tfoot";
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement(elemName, (UIComponent)uiData);
            if (header) {
                String headerStyleClass = HtmlTableRendererBase.getHeaderClass(uiData);
                if (facet != null) {
                    this.renderTableHeaderRow(facesContext, writer, uiData, facet, headerStyleClass, colspan);
                }
                if (hasColumnFacet) {
                    this.renderColumnHeaderRow(facesContext, writer, uiData, headerStyleClass);
                }
            } else {
                String footerStyleClass = HtmlTableRendererBase.getFooterClass(uiData);
                if (hasColumnFacet) {
                    this.renderColumnFooterRow(facesContext, writer, uiData, footerStyleClass);
                }
                if (facet != null) {
                    this.renderTableFooterRow(facesContext, writer, uiData, facet, footerStyleClass, colspan);
                }
            }
            writer.endElement(elemName);
        }
    }

    protected void renderTableHeaderRow(FacesContext facesContext, ResponseWriter writer, UIData uiData, UIComponent headerFacet, String headerStyleClass, int colspan) throws IOException {
        this.renderTableHeaderOrFooterRow(facesContext, writer, uiData, headerFacet, headerStyleClass, "th", colspan);
    }

    protected void renderTableFooterRow(FacesContext facesContext, ResponseWriter writer, UIData uiData, UIComponent footerFacet, String footerStyleClass, int colspan) throws IOException {
        this.renderTableHeaderOrFooterRow(facesContext, writer, uiData, footerFacet, footerStyleClass, "td", colspan);
    }

    protected void renderColumnHeaderRow(FacesContext facesContext, ResponseWriter writer, UIData uiData, String headerStyleClass) throws IOException {
        this.renderColumnHeaderOrFooterRow(facesContext, writer, uiData, headerStyleClass, true);
    }

    protected void renderColumnFooterRow(FacesContext facesContext, ResponseWriter writer, UIData uiData, String footerStyleClass) throws IOException {
        this.renderColumnHeaderOrFooterRow(facesContext, writer, uiData, footerStyleClass, false);
    }

    private void renderTableHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIData uiData, UIComponent facet, String styleClass, String colElementName, int colspan) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", (UIComponent)uiData);
        writer.startElement(colElementName, (UIComponent)uiData);
        if (colElementName.equals("th")) {
            writer.writeAttribute("scope", (Object)"colgroup", null);
        }
        writer.writeAttribute("colspan", (Object)new Integer(colspan), null);
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (facet != null) {
            RendererUtils.renderChild(facesContext, facet);
        }
        writer.endElement(colElementName);
        writer.endElement("tr");
    }

    private void renderColumnHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIData uiData, String styleClass, boolean header) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", (UIComponent)uiData);
        Iterator it = uiData.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent uiComponent = (UIComponent)it.next();
            if (!(uiComponent instanceof UIColumn) || !((UIColumn)uiComponent).isRendered()) continue;
            if (header) {
                this.renderColumnHeaderCell(facesContext, writer, (UIColumn)uiComponent, styleClass);
                continue;
            }
            this.renderColumnFooterCell(facesContext, writer, (UIColumn)uiComponent, styleClass);
        }
        writer.endElement("tr");
    }

    protected void renderColumnHeaderCell(FacesContext facesContext, ResponseWriter writer, UIColumn uiColumn, String headerStyleClass) throws IOException {
        UIComponent facet;
        writer.startElement("th", (UIComponent)uiColumn);
        if (headerStyleClass != null) {
            writer.writeAttribute("class", (Object)headerStyleClass, null);
        }
        if ((facet = uiColumn.getHeader()) != null) {
            RendererUtils.renderChild(facesContext, facet);
        }
        writer.endElement("th");
    }

    protected void renderColumnFooterCell(FacesContext facesContext, ResponseWriter writer, UIColumn uiColumn, String footerStyleClass) throws IOException {
        UIComponent facet;
        writer.startElement("td", (UIComponent)uiColumn);
        if (footerStyleClass != null) {
            writer.writeAttribute("class", (Object)footerStyleClass, null);
        }
        if ((facet = uiColumn.getFooter()) != null) {
            RendererUtils.renderChild(facesContext, facet);
        }
        writer.endElement("td");
    }

    private static String getHeaderClass(UIData component) {
        if (component instanceof HtmlDataTable) {
            return ((HtmlDataTable)component).getHeaderClass();
        }
        return (String)component.getAttributes().get("headerClass");
    }

    private static String getFooterClass(UIData component) {
        if (component instanceof HtmlDataTable) {
            return ((HtmlDataTable)component).getFooterClass();
        }
        return (String)component.getAttributes().get("footerClass");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Styles {
        private String[] _columnStyle;
        private String[] _rowStyle;

        Styles(String rowStyles, String columnStyles) {
            this._rowStyle = rowStyles == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(rowStyles, ','));
            this._columnStyle = columnStyles == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(columnStyles, ','));
        }

        public String getRowStyle(int idx) {
            if (!this.hasRowStyle()) {
                return null;
            }
            return this._rowStyle[idx % this._rowStyle.length];
        }

        public String getColumnStyle(int idx) {
            if (!this.hasColumnStyle()) {
                return null;
            }
            return this._columnStyle[idx % this._columnStyle.length];
        }

        public boolean hasRowStyle() {
            return this._rowStyle.length > 0;
        }

        public boolean hasColumnStyle() {
            return this._columnStyle.length > 0;
        }
    }
}

