/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.template.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.cyberneko.html.parsers.SAXParser;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.exception.SAXRuntimeException;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.jsf.template.TagSelector;
import org.seasar.jsf.template.ViewTemplate;
import org.seasar.jsf.template.ViewTemplateFactory;
import org.seasar.jsf.template.impl.TagSelectors;
import org.seasar.jsf.template.impl.ViewTemplateHandler;
import org.seasar.jsf.template.impl.ViewTemplateImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ViewTemplateFactoryImpl
implements ViewTemplateFactory {
    private S2Container container_;
    private String viewExtension_ = "html";
    private String encoding_ = "Windows-31j";
    private String contentType_ = "text/html;charset=" + this.encoding_;
    private TagSelectors tagSelectors_ = new TagSelectors();
    private Map viewTemplates_ = new HashMap();

    public String getViewExtension() {
        return this.viewExtension_;
    }

    public void setViewExtension(String viewExtension) {
        this.viewExtension_ = viewExtension;
    }

    public String getEncoding() {
        return this.encoding_;
    }

    public void setEncoding(String encoding) {
        this.encoding_ = encoding;
    }

    public String getContentType() {
        return this.contentType_;
    }

    public void setContentType(String contentType) {
        this.contentType_ = contentType;
    }

    public ViewTemplate getViewTemplate(String viewId) {
        ViewTemplate template = (ViewTemplate)this.viewTemplates_.get(viewId);
        if (template != null && !template.isModified()) {
            return template;
        }
        ServletContext ctx = this.container_.getRoot().getServletContext();
        SAXParser parser = this.createParser();
        String realPath = ctx.getRealPath(viewId);
        ViewTemplateHandler handler = new ViewTemplateHandler(this.tagSelectors_);
        parser.setContentHandler((ContentHandler)handler);
        try {
            parser.parse(new InputSource(ctx.getResourceAsStream(viewId)));
        }
        catch (SAXException ex) {
            throw new SAXRuntimeException(ex);
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
        template = new ViewTemplateImpl(viewId, handler.getRoot(), new File(realPath));
        this.viewTemplates_.put(viewId, template);
        return template;
    }

    public String calculateViewId(String viewId) {
        return String.valueOf(ResourceUtil.removeExtension((String)viewId)) + "." + this.viewExtension_;
    }

    protected TagSelector getTagSelector(String namespaceURI, String localName, String qName, Attributes attributes) {
        return this.tagSelectors_.getTagSelector(namespaceURI, localName, qName, attributes);
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    public void addTagSelector(TagSelector tagSelector) {
        this.tagSelectors_.addTagSelector(tagSelector);
    }

    protected SAXParser createParser() {
        SAXParser parser = new SAXParser();
        try {
            parser.setProperty("http://cyberneko.org/html/properties/default-encoding", (Object)this.encoding_);
            parser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"default");
            parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"match");
        }
        catch (SAXException ex) {
            throw new SAXRuntimeException(ex);
        }
        return parser;
    }
}

