package org.seasar.jsf.template.impl;

import java.util.ArrayList;
import java.util.List;

import javax.faces.component.UIComponent;

import org.seasar.jsf.template.ComponentTreeBuilder;

/**
 * @author higa
 *
 */
public abstract class AbstractComponentTreeBuilder implements ComponentTreeBuilder {

	private List children_ = new ArrayList();
	
	public AbstractComponentTreeBuilder() {
	}

	/**
	 * @see org.seasar.jsf.template.ComponentTreeBuilder#getChildCount()
	 */
	public int getChildCount() {
		return children_.size();
	}

	/**
	 * @see org.seasar.jsf.template.ComponentTreeBuilder#getChild(int)
	 */
	public ComponentTreeBuilder getChild(int index) {
		return (ComponentTreeBuilder) children_.get(index);
	}

	/**
	 * @see org.seasar.jsf.template.ComponentTreeBuilder#addChild(org.seasar.jsf.template.ComponentFactory)
	 */
	public void addChild(ComponentTreeBuilder componentFactory) {
		children_.add(componentFactory);
	}
	
	public void buildTree(UIComponent parent) {
		UIComponent component = createComponent();
		parent.getChildren().add(component);
	}
	
	protected abstract UIComponent createComponent();
}
