package org.seasar.jsf.template.impl.html;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.template.ComponentTreeBuilder;
import org.seasar.jsf.template.TagSelector;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class HtmlCommandButtonSelector implements TagSelector {

	public HtmlCommandButtonSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		if (!JsfConstants.INPUT_ELEM.equalsIgnoreCase(qName)) {
			return false;
		}
		String type = attributes.getValue(JsfConstants.TYPE_ATTR);
		String action = attributes.getValue(JsfConstants.S2JSF_NSURI,
				JsfConstants.ACTION_ATTR);
		return (JsfConstants.SUBMIT_VALUE.equalsIgnoreCase(type) || JsfConstants.BUTTON_VALUE
				.equalsIgnoreCase(type))
				&& action != null;
	}

	public ComponentTreeBuilder createBuilder(String namespaceURI,
			String localName, String qName, Attributes attributes) {

		return new HtmlCommandButtonBuilder(namespaceURI, localName, qName,
				attributes);
	}
}