package org.seasar.jsf.template.impl.html;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.template.ComponentTreeBuilder;
import org.seasar.jsf.template.TagSelector;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class HtmlMessagesSelector implements TagSelector {

	public HtmlMessagesSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		if (!JsfConstants.SPAN_ELEM.equalsIgnoreCase(qName)) {
			return false;
		}
		return JsfConstants.MESSAGES_VALUE.equalsIgnoreCase(attributes.getValue(
				JsfConstants.S2JSF_NSURI, JsfConstants.TYPE_ATTR));
	}

	public ComponentTreeBuilder createBuilder(String namespaceURI,
			String localName, String qName, Attributes attributes) {

		return new HtmlMessagesBuilder(namespaceURI, localName, qName,
				attributes);
	}
}