package org.seasar.jsf.template.impl.html;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.template.ComponentTreeBuilder;
import org.seasar.jsf.template.TagSelector;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class HtmlSelectBooleanCheckboxSelector implements TagSelector {

	public HtmlSelectBooleanCheckboxSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		if (!JsfConstants.INPUT_ELEM.equalsIgnoreCase(qName)) {
			return false;
		}
		return JsfConstants.CHECKBOX_VALUE.equalsIgnoreCase(attributes
				.getValue(JsfConstants.TYPE_ATTR));
	}

	public ComponentTreeBuilder createBuilder(String namespaceURI,
			String localName, String qName, Attributes attributes) {

		return new HtmlSelectBooleanCheckboxBuilder(namespaceURI, localName,
				qName, attributes);
	}
}