package org.seasar.jsf.template.impl.html;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.template.ComponentTreeBuilder;
import org.seasar.jsf.template.TagSelector;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class HtmlSelectOneMenuSelector implements TagSelector {

	public HtmlSelectOneMenuSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		if (!JsfConstants.SELECT_ELEM.equalsIgnoreCase(qName)) {
			return false;
		}
		return attributes.getValue(JsfConstants.MULTIPLE_ATTR) == null;
	}

	public ComponentTreeBuilder createBuilder(String namespaceURI,
			String localName, String qName, Attributes attributes) {

		return new HtmlSelectOneMenuBuilder(namespaceURI, localName, qName, attributes);
	}
}