package org.seasar.jsf.template.impl.html;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.template.ComponentTreeBuilder;
import org.seasar.jsf.template.TagSelector;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class HtmlSpanSelector implements TagSelector {

	public HtmlSpanSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		if (!JsfConstants.SPAN_ELEM.equalsIgnoreCase(qName)) {
			return false;
		}
		return attributes.getValue(JsfConstants.S2JSF_NSURI,
				JsfConstants.TYPE_ATTR) == null;
	}

	public ComponentTreeBuilder createBuilder(String namespaceURI,
			String localName, String qName, Attributes attributes) {

		return new HtmlSpanBuilder(namespaceURI, localName, qName, attributes);
	}
}