
package test.org.seasar.jsf.template.impl;

import java.io.InputStream;

import junit.framework.TestCase;

import org.cyberneko.html.parsers.SAXParser;
import org.seasar.framework.util.ResourceUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/**
 * @author Masataka Kurihara (Gluegent, Inc.)
 */
public class SaxParserTest extends TestCase implements ContentHandler {

    public SaxParserTest(String arg) {
        super(arg);
    }
    
    public void testSaxParse() throws Exception {
		SAXParser parser = new SAXParser();
		parser.setProperty("http://cyberneko.org/html/properties/default-encoding", "Shift_JIS");
		parser.setProperty("http://cyberneko.org/html/properties/names/attrs", "default");
		parser.setProperty("http://cyberneko.org/html/properties/names/elems", "match");
        InputStream stream = ResourceUtil.getResourceAsStream("test/org/seasar/jsf/template/impl/selectonemenu.html");  
        InputSource source = new InputSource(stream);
        parser.setContentHandler(this);
        parser.parse(source);
    }
    
    public void characters(char[] ch, int start, int length) throws SAXException {
        System.out.println("characters: " + new String(ch, start, length));
    }

    public void endDocument() throws SAXException {
        System.out.println("endDocument");
    }

    public void endElement(String namespaceURI, String localName, String qName)
            throws SAXException {
        System.out.println("endElement: " + localName);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        System.out.println("endPrefixMapping: " + prefix);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        System.out.println("ignorableWhitespace: length=" + length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        System.out.println("processingInstruction: " + target + " " + data);
    }

    public void setDocumentLocator(Locator locator) {
        System.out.println("setDocumentLocator");
    }

    public void skippedEntity(String name) throws SAXException {
        System.out.println("skippedEntity: " + name);
    }

    public void startDocument() throws SAXException {
        System.out.println("startDocument");
    }

    public void startElement(String namespaceURI, String localName,
            String qName, Attributes atts) throws SAXException {
        System.out.println("startElement: " + localName);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        System.out.println("startPrefixMapping: " + prefix + " " + uri);
    }
    
}
