/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.flash.decoder;

import com.carbonfive.flash.decoder.DecoderFactory;
import com.carbonfive.flash.decoder.NumberDecoder;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class NumberDecoderTest
extends TestCase {
    private DecoderFactory factory = null;
    private static final double DELTA = 1.0E-6;
    static /* synthetic */ Class class$com$carbonfive$flash$decoder$NumberDecoderTest;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public NumberDecoderTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(class$com$carbonfive$flash$decoder$NumberDecoderTest == null ? (class$com$carbonfive$flash$decoder$NumberDecoderTest = NumberDecoderTest.class$("com.carbonfive.flash.decoder.NumberDecoderTest")) : class$com$carbonfive$flash$decoder$NumberDecoderTest);
        return suite;
    }

    protected void setUp() throws Exception {
        this.factory = DecoderFactory.getInstance();
    }

    protected void tearDown() throws Exception {
        this.factory = null;
    }

    public void testNumberDecode() throws Exception {
        this.assertDecodable(class$java$lang$Byte == null ? (class$java$lang$Byte = NumberDecoderTest.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.assertDecodable(Byte.TYPE);
        this.assertDecodable(class$java$lang$Short == null ? (class$java$lang$Short = NumberDecoderTest.class$("java.lang.Short")) : class$java$lang$Short);
        this.assertDecodable(Short.TYPE);
        this.assertDecodable(class$java$lang$Integer == null ? (class$java$lang$Integer = NumberDecoderTest.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.assertDecodable(Integer.TYPE);
        this.assertDecodable(class$java$lang$Long == null ? (class$java$lang$Long = NumberDecoderTest.class$("java.lang.Long")) : class$java$lang$Long);
        this.assertDecodable(Long.TYPE);
        this.assertDecodable(class$java$lang$Float == null ? (class$java$lang$Float = NumberDecoderTest.class$("java.lang.Float")) : class$java$lang$Float);
        this.assertDecodable(Float.TYPE);
        this.assertDecodable(class$java$lang$Double == null ? (class$java$lang$Double = NumberDecoderTest.class$("java.lang.Double")) : class$java$lang$Double);
        this.assertDecodable(Double.TYPE);
        this.assertDecodable(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberDecoderTest.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
    }

    private void assertDecodable(Class desiredClass) throws Exception {
        NumberDecoder decoder = new NumberDecoder();
        Double encodedNumber = new Double(2.0);
        Object decodedNumber = decoder.decodeObject(encodedNumber, desiredClass);
        Class realDesiredClass = desiredClass.isPrimitive() ? NumberDecoderTest.getNonPrimative(desiredClass) : desiredClass;
        NumberDecoderTest.assertNotNull((Object)decodedNumber);
        NumberDecoderTest.assertEquals((Object)realDesiredClass, decodedNumber.getClass());
        NumberDecoderTest.assertEquals((double)encodedNumber, (double)((Number)decodedNumber).doubleValue(), (double)1.0E-6);
    }

    static final Class getNonPrimative(Class primitiveClass) {
        if (Byte.TYPE.equals(primitiveClass)) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = NumberDecoderTest.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (Short.TYPE.equals(primitiveClass)) {
            return class$java$lang$Short == null ? (class$java$lang$Short = NumberDecoderTest.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (Integer.TYPE.equals(primitiveClass)) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = NumberDecoderTest.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (Long.TYPE.equals(primitiveClass)) {
            return class$java$lang$Long == null ? (class$java$lang$Long = NumberDecoderTest.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (Float.TYPE.equals(primitiveClass)) {
            return class$java$lang$Float == null ? (class$java$lang$Float = NumberDecoderTest.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (Double.TYPE.equals(primitiveClass)) {
            return class$java$lang$Double == null ? (class$java$lang$Double = NumberDecoderTest.class$("java.lang.Double")) : class$java$lang$Double;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

