/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.lang.reflect.Array;
import org.seasar.framework.exception.EmptyRuntimeException;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static Object[] add(Object[] array, Object obj) {
        if (array == null) {
            throw new EmptyRuntimeException("array");
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = obj;
        return newArray;
    }

    public static int indexOf(Object[] array, Object obj) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                Object o = array[i];
                if (o != null ? o.equals(obj) : obj == null) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static Object[] remove(Object[] array, Object obj) {
        int index = ArrayUtil.indexOf(array, obj);
        if (index < 0) {
            return array;
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        if (index > 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        if (index < array.length - 1) {
            System.arraycopy(array, index + 1, newArray, index, newArray.length - index);
        }
        return newArray;
    }
}

