/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.seasar.jsf.util.BindingUtil;
import org.seasar.jsf.util.RenderUtil;

public class ForEach
extends UIComponentBase
implements NamingContainer {
    public static final String COMPONENT_TYPE = "org.seasar.jsf.ForEach";
    public static final String COMPONENT_FAMILY = "org.seasar.jsf.Logic";
    private static final Object[] EMPTY_ROWS = new Object[0];
    private String var;
    private String varIndex;
    private int rowIndex;
    private int rowCount;
    private Object[] rows = EMPTY_ROWS;
    private Map descendantComponentStates = new HashMap();

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getVarIndex() {
        return this.varIndex;
    }

    public void setVarIndex(String varIndex) {
        this.varIndex = varIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext extContext = context.getExternalContext();
        Map requestMap = extContext.getRequestMap();
        if (this.var != null) {
            requestMap.put(this.var, this.getCurrentRow());
        }
        if (this.varIndex != null) {
            requestMap.put(this.varIndex, new Integer(rowIndex));
        }
    }

    public Object getCurrentRow() {
        return this.rows[this.rowIndex];
    }

    protected void setupRows() {
        Object items = BindingUtil.getBindingValue((UIComponent)this, "items");
        if (items == null) {
            this.rows = new Object[this.rowCount];
        } else if (items instanceof Collection) {
            this.rows = new ArrayList((Collection)items).toArray();
        } else if (items.getClass().isArray()) {
            this.rows = (Object[])items;
        } else {
            throw new IllegalStateException("items");
        }
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new ForEachEvent(event, this.getRowIndex(), this));
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof ForEachEvent) {
            ForEachEvent fee = (ForEachEvent)event;
            this.setRowIndex(fee.getRowIndex());
            FacesEvent original = fee.getOriginal();
            original.getComponent().broadcast(original);
        } else {
            super.broadcast(event);
        }
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.setupRows();
        int i = 0;
        while (i < this.rows.length) {
            this.setRowIndex(i);
            this.restoreDescendantComponentStates(context, (UIComponent)this);
            super.processDecodes(context);
            this.saveDescendantComponentStates(context, (UIComponent)this);
            ++i;
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        int i = 0;
        while (i < this.rows.length) {
            this.setRowIndex(i);
            this.restoreDescendantComponentStates(context, (UIComponent)this);
            super.processValidators(context);
            this.saveDescendantComponentStates(context, (UIComponent)this);
            ++i;
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        int i = 0;
        while (i < this.rows.length) {
            this.setRowIndex(i);
            this.restoreDescendantComponentStates(context, (UIComponent)this);
            super.processUpdates(context);
            this.saveDescendantComponentStates(context, (UIComponent)this);
            ++i;
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        this.setupRows();
        this.rowCount = this.rows.length;
        int i = 0;
        while (i < this.rows.length) {
            this.setRowIndex(i);
            this.refreshDescendantComponentClientId(context, (UIComponent)this);
            RenderUtil.encodeChildren(context, (UIComponent)this);
            this.saveDescendantComponentStates(context, (UIComponent)this);
            ++i;
        }
    }

    protected void saveDescendantComponentStates(FacesContext context, UIComponent component) {
        List children = component.getChildren();
        int i = 0;
        while (i < children.size()) {
            UIComponent child = (UIComponent)children.get(i);
            if (child instanceof EditableValueHolder) {
                EditableValueHolder evh = (EditableValueHolder)child;
                this.descendantComponentStates.put(child.getClientId(context), new EditableValueHolderState(evh));
            }
            this.saveDescendantComponentStates(context, child);
            ++i;
        }
    }

    protected void restoreDescendantComponentStates(FacesContext context, UIComponent component) {
        List children = component.getChildren();
        int i = 0;
        while (i < children.size()) {
            UIComponent child = (UIComponent)children.get(i);
            child.setId(child.getId());
            if (child instanceof EditableValueHolder) {
                EditableValueHolder evh = (EditableValueHolder)child;
                EditableValueHolderState state = (EditableValueHolderState)this.descendantComponentStates.get(child.getClientId(context));
                state.restore(evh);
            }
            this.restoreDescendantComponentStates(context, child);
            ++i;
        }
    }

    protected void refreshDescendantComponentClientId(FacesContext context, UIComponent component) {
        List children = component.getChildren();
        int i = 0;
        while (i < children.size()) {
            UIComponent child = (UIComponent)children.get(i);
            child.setId(child.getId());
            this.refreshDescendantComponentClientId(context, child);
            ++i;
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.var, this.varIndex, this.descendantComponentStates, new Integer(this.rowCount)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.var = (String)values[1];
        this.varIndex = (String)values[2];
        this.descendantComponentStates = (Map)values[3];
        this.rowCount = (Integer)values[4];
    }

    public String getClientId(FacesContext context) {
        String clientId = super.getClientId(context);
        int rowIndex = this.getRowIndex();
        if (rowIndex == -1) {
            return clientId;
        }
        return String.valueOf(clientId) + "_" + rowIndex;
    }

    private static class EditableValueHolderState
    implements Serializable {
        private Object localValue;
        private boolean localValueSet;
        private boolean valid;
        private Object submittedValue;

        public EditableValueHolderState(EditableValueHolder evh) {
            this.localValue = evh.getLocalValue();
            this.localValueSet = evh.isLocalValueSet();
            this.valid = evh.isValid();
            this.submittedValue = evh.getSubmittedValue();
        }

        public void restore(EditableValueHolder evh) {
            evh.setValue(this.localValue);
            evh.setLocalValueSet(this.localValueSet);
            evh.setValid(this.valid);
            evh.setSubmittedValue(this.submittedValue);
        }
    }

    private static class ForEachEvent
    extends FacesEvent {
        private FacesEvent original;
        private int rowIndex;

        public ForEachEvent(FacesEvent original, int rowIndex, ForEach forEach) {
            super((UIComponent)forEach);
            this.original = original;
            this.rowIndex = rowIndex;
        }

        public PhaseId getPhaseId() {
            return this.original.getPhaseId();
        }

        public void setPhaseId(PhaseId phaseId) {
            this.original.setPhaseId(phaseId);
        }

        public void queue() {
            this.original.queue();
        }

        public String toString() {
            return this.original.toString();
        }

        public boolean isAppropriateListener(FacesListener listener) {
            return this.original.isAppropriateListener(listener);
        }

        public void processListener(FacesListener listener) {
            this.original.processListener(listener);
        }

        public FacesEvent getOriginal() {
            return this.original;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }
    }
}

