/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.jsp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspWriter;
import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.exception.StreamClosedException;

public class JspWriterImpl
extends JspWriter {
    private Writer out;
    private ServletResponse response;
    private char[] cb;
    private int nextChar;
    private boolean closed = false;

    public JspWriterImpl() {
        super(8192, true);
    }

    public JspWriterImpl(ServletResponse response) {
        this(response, 8192, true);
    }

    public JspWriterImpl(ServletResponse response, int size, boolean autoFlush) {
        super(size, autoFlush);
        this.response = response;
        this.cb = new char[size];
        this.nextChar = 0;
    }

    protected final void flushBuffer() throws IOException {
        if (this.bufferSize == 0) {
            return;
        }
        this.ensureOpen();
        if (this.nextChar == 0) {
            return;
        }
        this.initOut();
        this.out.write(this.cb, 0, this.nextChar);
        this.nextChar = 0;
    }

    protected void initOut() throws IOException {
        if (this.out == null) {
            String encoding = this.response.getCharacterEncoding();
            this.out = encoding != null ? new OutputStreamWriter((OutputStream)this.response.getOutputStream(), encoding) : this.response.getWriter();
        }
    }

    public final void clear() throws IOException {
        this.clearBuffer();
    }

    public void clearBuffer() throws IOException {
        this.ensureOpen();
        this.nextChar = 0;
    }

    public void flush() throws IOException {
        this.flushBuffer();
        if (this.out != null) {
            this.out.flush();
            this.response.flushBuffer();
        }
    }

    public void close() throws IOException {
        if (this.response == null || this.closed) {
            return;
        }
        this.flush();
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.response = null;
        this.closed = true;
    }

    public int getRemaining() {
        return this.bufferSize - this.nextChar;
    }

    protected void ensureOpen() throws IOException {
        if (this.response == null || this.closed) {
            throw new StreamClosedException();
        }
    }

    public void write(int c) throws IOException {
        this.ensureOpen();
        if (this.bufferSize == 0) {
            this.initOut();
            this.out.write(c);
        } else {
            this.checkBufferOverflow();
            this.cb[this.nextChar++] = (char)c;
        }
    }

    protected void checkBufferOverflow() throws IOException {
        if (this.nextChar >= this.bufferSize) {
            if (this.autoFlush) {
                this.flushBuffer();
            } else {
                throw new IOException("buffer overflow");
            }
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        if (this.bufferSize == 0) {
            this.initOut();
            this.out.write(cbuf, off, len);
            return;
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int b = off;
        int t = off + len;
        while (b < t) {
            int d = Math.min(this.bufferSize - this.nextChar, t - b);
            System.arraycopy(cbuf, b, this.cb, this.nextChar, d);
            b += d;
            this.nextChar += d;
            this.checkBufferOverflow();
        }
    }

    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(String s, int off, int len) throws IOException {
        this.ensureOpen();
        if (this.bufferSize == 0) {
            this.initOut();
            this.out.write(s, off, len);
            return;
        }
        int b = off;
        int t = off + len;
        while (b < t) {
            int d = Math.min(this.bufferSize - this.nextChar, t - b);
            s.getChars(b, b + d, this.cb, this.nextChar);
            b += d;
            this.nextChar += d;
            this.checkBufferOverflow();
        }
    }

    public void write(String s) throws IOException {
        this.write(s, 0, s.length());
    }

    public void newLine() throws IOException {
        this.write(JsfConstants.LINE_SP);
    }

    public void print(boolean b) throws IOException {
        this.write(b ? "true" : "false");
    }

    public void print(char c) throws IOException {
        this.write(String.valueOf(c));
    }

    public void print(int i) throws IOException {
        this.write(String.valueOf(i));
    }

    public void print(long l) throws IOException {
        this.write(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void print(char[] s) throws IOException {
        this.write(s);
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    public void print(Object o) throws IOException {
        this.write(String.valueOf(o));
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean b) throws IOException {
        this.print(b);
        this.println();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.println();
    }

    public void println(int i) throws IOException {
        this.print(i);
        this.println();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.println();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.println();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.println();
    }

    public void println(char[] s) throws IOException {
        this.print(s);
        this.println();
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.println();
    }

    public void println(Object o) throws IOException {
        this.print(o);
        this.println();
    }
}

