/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.htmlEditor;

import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.ext.HtmlInputText;
import org.apache.myfaces.renderkit.RendererUtils;

public class HtmlEditor
extends HtmlInputText {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlEditor";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.HtmlEditor";
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$component$html$ext$HtmlInputText == null ? (class$org$apache$myfaces$component$html$ext$HtmlInputText = HtmlEditor.class$("org.apache.myfaces.component.html.ext.HtmlInputText")) : class$org$apache$myfaces$component$html$ext$HtmlInputText));
    private String _style;
    private String _styleClass;
    private String _type;
    private Boolean _allowEditSource;
    private Boolean _addKupuLogo;
    private Boolean _showPropertiesToolBox;
    private Boolean _showLinksToolBox;
    private Boolean _showImagesToolBox;
    private Boolean _showTablesToolBox;
    private Boolean _showDebugToolBox;
    private Boolean _enableFlexiTools;
    static /* synthetic */ Class class$org$apache$myfaces$component$html$ext$HtmlInputText;

    public HtmlEditor() {
        this.setRendererType("org.apache.myfaces.HtmlEditor");
    }

    public String getFamily() {
        return "javax.faces.Input";
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[6];
        values[0] = super.saveState(context);
        String[] display = new String[]{this._style, this._styleClass};
        values[1] = display;
        values[2] = this._type;
        Boolean[] toolBarButtons = new Boolean[]{this._allowEditSource, this._addKupuLogo};
        values[3] = toolBarButtons;
        Boolean[] toolBoxes = new Boolean[]{this._showPropertiesToolBox, this._showLinksToolBox, this._showImagesToolBox, this._showTablesToolBox, this._showDebugToolBox};
        values[4] = toolBoxes;
        Boolean[] tools = new Boolean[]{this._enableFlexiTools};
        values[5] = tools;
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        String[] display = (String[])values[1];
        this._style = display[0];
        this._styleClass = display[1];
        this._type = (String)values[2];
        Boolean[] toolBarButtons = (Boolean[])values[3];
        this._allowEditSource = toolBarButtons[0];
        this._addKupuLogo = toolBarButtons[1];
        Boolean[] toolBoxes = (Boolean[])values[4];
        this._showPropertiesToolBox = toolBoxes[0];
        this._showLinksToolBox = toolBoxes[1];
        this._showImagesToolBox = toolBoxes[2];
        this._showTablesToolBox = toolBoxes[3];
        this._showDebugToolBox = toolBoxes[4];
        Boolean[] tools = (Boolean[])values[5];
        this._enableFlexiTools = tools[0];
    }

    public String getStyle() {
        if (this._style != null) {
            return this._style;
        }
        ValueBinding vb = this.getValueBinding("style");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setStyle(String style) {
        this._style = style;
    }

    public String getStyleClass() {
        if (this._styleClass != null) {
            return this._styleClass;
        }
        ValueBinding vb = this.getValueBinding("styleClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setStyleClass(String styleClass) {
        this._styleClass = styleClass;
    }

    public String getType() {
        if (this._type != null) {
            return this._type;
        }
        ValueBinding vb = this.getValueBinding("type");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "fragment";
    }

    public void setType(String _type) {
        this._type = _type;
    }

    public boolean isTypeDocument() {
        return this.getType().equals("document");
    }

    public Boolean isAllowEditSource() {
        if (this._allowEditSource != null) {
            return this._allowEditSource;
        }
        ValueBinding vb = this.getValueBinding("allowEditSource");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : Boolean.TRUE;
    }

    public boolean isAddKupuLogo() {
        if (this._addKupuLogo != null) {
            return this._addKupuLogo;
        }
        ValueBinding vb = this.getValueBinding("addKupuLogo");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : true;
    }

    public void setAddKupuLogo(boolean addKupuLogo) {
        this._addKupuLogo = addKupuLogo;
    }

    public boolean isShowPropertiesToolBox() {
        if (this._showPropertiesToolBox != null) {
            return this._showPropertiesToolBox;
        }
        ValueBinding vb = this.getValueBinding("showPropertiesToolBox");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setShowPropertiesToolBox(boolean showPropertiesToolBox) {
        this._showPropertiesToolBox = showPropertiesToolBox;
    }

    public boolean isShowLinksToolBox() {
        if (this._showLinksToolBox != null) {
            return this._showLinksToolBox;
        }
        ValueBinding vb = this.getValueBinding("showLinksToolBox");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setShowLinksToolBox(boolean showLinksToolBox) {
        this._showLinksToolBox = showLinksToolBox;
    }

    public boolean isShowImagesToolBox() {
        if (this._showImagesToolBox != null) {
            return this._showImagesToolBox;
        }
        ValueBinding vb = this.getValueBinding("showImagesToolBox");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setShowImagesToolBox(boolean showImagesToolBox) {
        this._showImagesToolBox = showImagesToolBox;
    }

    public boolean isShowTablesToolBox() {
        if (this._showTablesToolBox != null) {
            return this._showTablesToolBox;
        }
        ValueBinding vb = this.getValueBinding("showTablesToolBox");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setShowTablesToolBox(boolean showTablesToolBox) {
        this._showTablesToolBox = showTablesToolBox;
    }

    public boolean isShowDebugToolBox() {
        if (this._showDebugToolBox != null) {
            return this._showDebugToolBox;
        }
        ValueBinding vb = this.getValueBinding("showDebugToolBox");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setShowDebugToolBox(boolean showTablesToolBox) {
        this._showDebugToolBox = showTablesToolBox;
    }

    public boolean isShowAnyToolBox() {
        return this.isShowPropertiesToolBox() || this.isShowLinksToolBox() || this.isShowImagesToolBox() || this.isShowTablesToolBox() || this.isShowDebugToolBox();
    }

    public boolean isEnableFlexiTools() {
        if (this._enableFlexiTools != null) {
            return this._enableFlexiTools;
        }
        ValueBinding vb = this.getValueBinding("formularMode");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setEnableFlexiTools(boolean formularMode) {
        this._enableFlexiTools = formularMode;
    }

    public String getValueAsHtmlDocument(FacesContext context) {
        String val = RendererUtils.getStringValue(context, this);
        if (HtmlEditor.isHtmlDocument(val)) {
            return val;
        }
        return "<html><body>" + (val == null ? "" : val) + "</body></html>";
    }

    private static boolean isHtmlDocument(String text) {
        if (text == null) {
            return false;
        }
        return text.indexOf("<body>") != -1 || text.indexOf("<body ") != -1 || text.indexOf("<BODY>") != -1 || text.indexOf("<BODY ") != -1;
    }

    public String getValueFromDocument(String text) {
        char c;
        if (text == null) {
            return "";
        }
        if (this.isTypeDocument()) {
            return text.trim();
        }
        if (!HtmlEditor.isHtmlDocument(text)) {
            return text.trim();
        }
        String lcText = text.toLowerCase();
        int textLength = lcText.length();
        int bodyStartIndex = 0;
        while (bodyStartIndex < textLength && (bodyStartIndex = lcText.indexOf("<body")) != -1 && (c = lcText.charAt(bodyStartIndex += 5)) != '>') {
            if (c != ' ' && c != '\t') continue;
            bodyStartIndex = lcText.indexOf(62, bodyStartIndex);
        }
        int bodyEndIndex = lcText.lastIndexOf("</body>") - 1;
        if (++bodyStartIndex < 0 || bodyEndIndex < 0 || bodyStartIndex > bodyEndIndex || bodyStartIndex >= textLength || bodyEndIndex >= textLength) {
            log.warn((Object)("Couldn't extract HTML body from :\n" + text));
            return text.trim();
        }
        return text.substring(bodyStartIndex, bodyEndIndex + 1).trim();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

