/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.Hibernate;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.NoArgSQLFunction;
import net.sf.hibernate.dialect.StandardSQLFunction;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.sql.OracleJoinFragment;

public class TimesTenDialect
extends Dialect {
    public TimesTenDialect() {
        this.registerColumnType(-7, "TINYINT");
        this.registerColumnType(-5, "BIGINT");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(-6, "TINYINT");
        this.registerColumnType(4, "INTEGER");
        this.registerColumnType(1, "CHAR(1)");
        this.registerColumnType(12, "VARCHAR($l)");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(8, "DOUBLE");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "TIMESTAMP");
        this.registerColumnType(-3, "VARBINARY($l)");
        this.registerColumnType(2, "DECIMAL(19, $l)");
        this.registerColumnType(2004, "VARBINARY(4000000)");
        this.registerColumnType(2005, "VARCHAR(4000000)");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.registerFunction("lower", new StandardSQLFunction());
        this.registerFunction("upper", new StandardSQLFunction());
        this.registerFunction("rtrim", new StandardSQLFunction());
        this.registerFunction("concat", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("mod", new StandardSQLFunction());
        this.registerFunction("to_char", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("to_date", new StandardSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("sysdate", new NoArgSQLFunction(Hibernate.DATE, false));
        this.registerFunction("getdate", new NoArgSQLFunction(Hibernate.DATE, false));
        this.registerFunction("nvl", new StandardSQLFunction());
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public boolean supportsUnique() {
        return false;
    }

    public boolean supportsUniqueConstraintInCreateAlterTable() {
        return false;
    }

    public String getAddColumnString() {
        return "add";
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select first 1 " + sequenceName + ".nextval from sys.tables";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public String getQuerySequencesString() {
        return "select NAME from sys.sequences";
    }

    public JoinFragment createOuterJoinFragment() {
        return new OracleJoinFragment();
    }

    public boolean supportsForUpdateNowait() {
        return false;
    }

    public boolean supportsCheck() {
        return false;
    }
}

