/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.CacheEntry;
import net.sf.hibernate.impl.ScheduledEntityAction;
import net.sf.hibernate.impl.SessionImpl;
import net.sf.hibernate.persister.ClassPersister;

final class ScheduledUpdate
extends ScheduledEntityAction
implements SessionImpl.Executable,
Serializable {
    private final Object[] fields;
    private final Object[] oldFields;
    private final Object lastVersion;
    private final Object nextVersion;
    private final int[] dirtyFields;
    private final Object[] updatedState;
    private CacheEntry cacheEntry;
    private CacheConcurrencyStrategy.SoftLock lock;

    public ScheduledUpdate(Serializable id, Object[] fields, int[] dirtyProperties, Object[] oldFields, Object lastVersion, Object nextVersion, Object instance, Object[] updatedState, ClassPersister persister, SessionImplementor session) throws HibernateException {
        super(session, id, instance, persister);
        this.fields = fields;
        this.oldFields = oldFields;
        this.lastVersion = lastVersion;
        this.nextVersion = nextVersion;
        this.dirtyFields = dirtyProperties;
        this.updatedState = updatedState;
    }

    public void execute() throws HibernateException {
        Serializable id = this.getId();
        ClassPersister persister = this.getPersister();
        SessionImplementor session = this.getSession();
        Object instance = this.getInstance();
        if (persister.hasCache()) {
            this.lock = persister.getCache().lock(id, this.lastVersion);
        }
        persister.update(id, this.fields, this.dirtyFields, this.oldFields, this.lastVersion, instance, session);
        session.postUpdate(instance, this.updatedState, this.nextVersion);
        if (persister.hasCache()) {
            if (persister.isCacheInvalidationRequired()) {
                persister.getCache().evict(id);
            } else {
                this.cacheEntry = new CacheEntry(instance, persister, this.getSession());
                persister.getCache().update(id, this.cacheEntry);
            }
        }
    }

    public void afterTransactionCompletion(boolean success) throws CacheException {
        ClassPersister persister = this.getPersister();
        if (persister.hasCache()) {
            if (success && !persister.isCacheInvalidationRequired()) {
                persister.getCache().afterUpdate(this.getId(), this.cacheEntry, this.nextVersion, this.lock);
            } else {
                persister.getCache().release(this.getId(), this.lock);
            }
        }
    }
}

