/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.transaction;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.transaction.TransactionManagerLookup;
import net.sf.hibernate.util.NamingHelper;

public class WebSphereExtendedJTATransactionLookup
implements TransactionManagerLookup {
    public TransactionManager getTransactionManager(Properties props) throws HibernateException {
        return new TransactionManagerAdapter(props);
    }

    public String getUserTransactionName() {
        return "java:comp/UserTransaction";
    }

    public static class TransactionManagerAdapter
    implements TransactionManager {
        private final Properties properties;
        private final Class synchronizationCallbackClass;
        private final Method registerSynchronizationMethod;

        private TransactionManagerAdapter(Properties props) throws HibernateException {
            this.properties = props;
            try {
                this.synchronizationCallbackClass = Class.forName("com.ibm.websphere.jtaextensions.SynchronizationCallback");
                this.registerSynchronizationMethod = Class.forName("com.ibm.websphere.jtaextensions.ExtendedJTATransaction").getMethod("registerSynchronizationCallback", this.synchronizationCallbackClass);
            }
            catch (ClassNotFoundException cnfe) {
                throw new HibernateException(cnfe);
            }
            catch (NoSuchMethodException nsme) {
                throw new HibernateException(nsme);
            }
        }

        public void begin() throws NotSupportedException, SystemException {
            throw new UnsupportedOperationException();
        }

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            throw new UnsupportedOperationException();
        }

        public int getStatus() throws SystemException {
            throw new UnsupportedOperationException();
        }

        public Transaction getTransaction() throws SystemException {
            return new TransactionAdapter(this.properties);
        }

        public void resume(Transaction txn) throws InvalidTransactionException, IllegalStateException, SystemException {
            throw new UnsupportedOperationException();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            throw new UnsupportedOperationException();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            throw new UnsupportedOperationException();
        }

        public void setTransactionTimeout(int i) throws SystemException {
            throw new UnsupportedOperationException();
        }

        public Transaction suspend() throws SystemException {
            throw new UnsupportedOperationException();
        }

        public class TransactionAdapter
        implements Transaction {
            private final Object extendedJTATransaction;

            private TransactionAdapter(Properties props) throws SystemException {
                try {
                    this.extendedJTATransaction = NamingHelper.getInitialContext(props).lookup("java:comp/websphere/ExtendedJTATransaction");
                }
                catch (NamingException ne) {
                    throw new SystemException(ne.getMessage());
                }
            }

            public void registerSynchronization(final Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
                InvocationHandler ih = new InvocationHandler(){

                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if ("afterCompletion".equals(method.getName())) {
                            int status = args[3].equals(Boolean.TRUE) ? 3 : 5;
                            synchronization.afterCompletion(status);
                        } else if ("beforeCompletion".equals(method.getName())) {
                            synchronization.beforeCompletion();
                        }
                        return null;
                    }
                };
                Object synchronizationCallback = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{TransactionManagerAdapter.this.synchronizationCallbackClass}, ih);
                try {
                    TransactionManagerAdapter.this.registerSynchronizationMethod.invoke(this.extendedJTATransaction, synchronizationCallback);
                }
                catch (Exception e) {
                    throw new SystemException(e.getMessage());
                }
            }

            public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
                throw new UnsupportedOperationException();
            }

            public boolean delistResource(XAResource resource, int i) throws IllegalStateException, SystemException {
                throw new UnsupportedOperationException();
            }

            public boolean enlistResource(XAResource resource) throws RollbackException, IllegalStateException, SystemException {
                throw new UnsupportedOperationException();
            }

            public int getStatus() throws SystemException {
                throw new UnsupportedOperationException();
            }

            public void rollback() throws IllegalStateException, SystemException {
                throw new UnsupportedOperationException();
            }

            public void setRollbackOnly() throws IllegalStateException, SystemException {
                throw new UnsupportedOperationException();
            }
        }
    }
}

