/*
 * Decompiled with CFR 0.152.
 */
package javassist.expr;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ExceptionTable;
import javassist.bytecode.MethodInfo;
import javassist.expr.Cast;
import javassist.expr.Expr;
import javassist.expr.FieldAccess;
import javassist.expr.Handler;
import javassist.expr.Instanceof;
import javassist.expr.MethodCall;
import javassist.expr.NewArray;
import javassist.expr.NewExpr;

public class ExprEditor {
    public boolean doit(CtClass clazz, MethodInfo minfo) throws CannotCompileException {
        CodeAttribute codeAttr = minfo.getCodeAttribute();
        if (codeAttr == null) {
            return false;
        }
        CodeIterator iterator = codeAttr.iterator();
        boolean edited = false;
        int maxLocals = codeAttr.getMaxLocals();
        int maxStack = 0;
        NewOp newList = null;
        ConstPool cp = minfo.getConstPool();
        while (iterator.hasNext()) {
            try {
                Expr expr = null;
                int pos = iterator.next();
                int c = iterator.byteAt(pos);
                if (c >= 178) {
                    if (c < 188) {
                        if (c == 184 || c == 185 || c == 182) {
                            expr = new MethodCall(pos, iterator, clazz, minfo);
                            this.edit((MethodCall)expr);
                        } else if (c == 180 || c == 178 || c == 181 || c == 179) {
                            expr = new FieldAccess(pos, iterator, clazz, minfo, c);
                            this.edit((FieldAccess)expr);
                        } else if (c == 187) {
                            int index = iterator.u16bitAt(pos + 1);
                            newList = new NewOp(newList, pos, cp.getClassInfo(index));
                        } else if (c == 183) {
                            if (newList != null && cp.isConstructor(newList.type, iterator.u16bitAt(pos + 1)) > 0) {
                                expr = new NewExpr(pos, iterator, clazz, minfo, newList.type, newList.pos);
                                this.edit((NewExpr)expr);
                                newList = newList.next;
                            } else {
                                expr = new MethodCall(pos, iterator, clazz, minfo);
                                MethodCall mcall = (MethodCall)expr;
                                if (!mcall.getMethodName().equals("<init>")) {
                                    this.edit(mcall);
                                }
                            }
                        }
                    } else if (c == 188 || c == 189 || c == 197) {
                        expr = new NewArray(pos, iterator, clazz, minfo, c);
                        this.edit((NewArray)expr);
                    } else if (c == 193) {
                        expr = new Instanceof(pos, iterator, clazz, minfo);
                        this.edit((Instanceof)expr);
                    } else if (c == 192) {
                        expr = new Cast(pos, iterator, clazz, minfo);
                        this.edit((Cast)expr);
                    }
                }
                if (expr == null || !expr.edited()) continue;
                edited = true;
                maxLocals = this.max(maxLocals, expr.locals());
                maxStack = this.max(maxStack, expr.stack());
            }
            catch (BadBytecode e) {
                throw new CannotCompileException(e);
            }
        }
        ExceptionTable et = codeAttr.getExceptionTable();
        int n = et.size();
        for (int i = 0; i < n; ++i) {
            Handler h = new Handler(et, i, iterator, clazz, minfo);
            this.edit(h);
            if (!h.edited()) continue;
            edited = true;
            maxLocals = this.max(maxLocals, h.locals());
            maxStack = this.max(maxStack, h.stack());
        }
        codeAttr.setMaxLocals(maxLocals);
        codeAttr.setMaxStack(codeAttr.getMaxStack() + maxStack);
        return edited;
    }

    private int max(int i, int j) {
        return i > j ? i : j;
    }

    public void edit(NewExpr e) throws CannotCompileException {
    }

    public void edit(NewArray a) throws CannotCompileException {
    }

    public void edit(MethodCall m) throws CannotCompileException {
    }

    public void edit(FieldAccess f) throws CannotCompileException {
    }

    public void edit(Instanceof i) throws CannotCompileException {
    }

    public void edit(Cast c) throws CannotCompileException {
    }

    public void edit(Handler h) throws CannotCompileException {
    }

    static class NewOp {
        NewOp next;
        int pos;
        String type;

        NewOp(NewOp n, int p, String t) {
            this.next = n;
            this.pos = p;
            this.type = t;
        }
    }
}

