/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.lang.reflect.Field;
import org.seasar.dao.DaoAnnotationReader;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.StringUtil;

public class FieldAnnotationReader
implements DaoAnnotationReader {
    public String BEAN = "BEAN";
    public String ARGS_SUFFIX = "_ARGS";
    public String SQL_SUFFIX = "_SQL";
    public String QUERY_SUFFIX = "_QUERY";
    public String NO_PERSISTENT_PROPS_SUFFIX = "_NO_PERSISTENT_PROPS";
    public String PERSISTENT_PROPS_SUFFIX = "_PERSISTENT_PROPS";
    protected BeanDesc daoBeanDesc_;

    public FieldAnnotationReader(BeanDesc daoBeanDesc_) {
        this.daoBeanDesc_ = daoBeanDesc_;
    }

    public String[] getArgNames(String methodName) {
        String argsKey = String.valueOf(methodName) + this.ARGS_SUFFIX;
        if (this.daoBeanDesc_.hasField(argsKey)) {
            Field argNamesField = this.daoBeanDesc_.getField(argsKey);
            String argNames = (String)FieldUtil.get((Field)argNamesField, null);
            return StringUtil.split((String)argNames, (String)" ,");
        }
        return new String[0];
    }

    public String getQuery(String methodName) {
        String key = String.valueOf(methodName) + this.QUERY_SUFFIX;
        if (this.daoBeanDesc_.hasField(key)) {
            Field queryField = this.daoBeanDesc_.getField(key);
            return (String)FieldUtil.get((Field)queryField, null);
        }
        return null;
    }

    public Class getBeanClass() {
        Field beanField = this.daoBeanDesc_.getField(this.BEAN);
        return (Class)FieldUtil.get((Field)beanField, null);
    }

    public String[] getNoPersistentProps(String methodName) {
        return this.getProps(methodName, String.valueOf(methodName) + this.NO_PERSISTENT_PROPS_SUFFIX);
    }

    public String[] getPersistentProps(String methodName) {
        return this.getProps(methodName, String.valueOf(methodName) + this.PERSISTENT_PROPS_SUFFIX);
    }

    private String[] getProps(String methodName, String fieldName) {
        if (this.daoBeanDesc_.hasField(fieldName)) {
            Field field = this.daoBeanDesc_.getField(fieldName);
            String s = (String)FieldUtil.get((Field)field, null);
            return StringUtil.split((String)s, (String)", ");
        }
        return null;
    }

    public String getSQL(String methodName, String dbmsSuffix) {
        String key = String.valueOf(methodName) + dbmsSuffix + this.SQL_SUFFIX;
        if (this.daoBeanDesc_.hasField(key)) {
            Field queryField = this.daoBeanDesc_.getField(key);
            return (String)FieldUtil.get((Field)queryField, null);
        }
        key = String.valueOf(methodName) + this.SQL_SUFFIX;
        if (this.daoBeanDesc_.hasField(key)) {
            Field queryField = this.daoBeanDesc_.getField(key);
            return (String)FieldUtil.get((Field)queryField, null);
        }
        return null;
    }
}

