/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.runtime;

import java.util.Stack;
import org.seasar.jsf.JsfConfig;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.TagSelector;
import org.seasar.jsf.ViewTemplateFactory;
import org.seasar.jsf.processor.ElementProcessor;
import org.seasar.jsf.processor.TextProcessor;
import org.seasar.jsf.processor.ViewProcessor;
import org.seasar.jsf.runtime.TagSelectors;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TagProcessorHandler
extends DefaultHandler {
    private TagSelectors tagSelectors;
    private JsfConfig jsfConfig;
    private Stack processorStack = new Stack();
    private TagProcessor root;

    public TagProcessorHandler(TagSelectors tagSelectors, JsfConfig jsfConfig, ViewTemplateFactory viewTemplateFactory) {
        this.tagSelectors = tagSelectors;
        this.jsfConfig = jsfConfig;
        this.root = new ViewProcessor(jsfConfig, viewTemplateFactory);
    }

    public TagProcessor getRoot() {
        return this.root;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
        TagSelector selector = this.tagSelectors.getTagSelector(namespaceURI, localName, qName, attributes);
        TagProcessor processor = null;
        if (selector != null) {
            processor = selector.createProcessor();
        }
        if (!this.processorStack.isEmpty()) {
            TagProcessor parentProcessor = this.peekProcessor();
            if (parentProcessor != null) {
                if (processor instanceof ElementProcessor && "br".equalsIgnoreCase(qName)) {
                    this.addText(parentProcessor, "<br />");
                } else {
                    parentProcessor.addChild(processor);
                }
            }
        } else {
            this.root.addChild(processor);
        }
        processor.setup(namespaceURI, localName, qName, attributes, this.jsfConfig);
        this.processorStack.push(processor);
    }

    protected TagProcessor peekProcessor() {
        return (TagProcessor)this.processorStack.peek();
    }

    protected TagProcessor popProcessor() {
        return (TagProcessor)this.processorStack.pop();
    }

    public void characters(char[] buffer, int start, int length) {
        TagProcessor processor = null;
        if (!this.processorStack.isEmpty()) {
            processor = this.peekProcessor();
            if (processor == null) {
                return;
            }
        } else {
            processor = this.root;
        }
        String text = new String(buffer, start, length);
        this.addText(processor, text);
    }

    protected void addText(TagProcessor processor, String text) {
        TagProcessor child = this.getPreviousChildProcessor(processor);
        if (child instanceof ElementProcessor) {
            ((ElementProcessor)child).addAfterContents(text);
        } else if (child instanceof TextProcessor) {
            ((TextProcessor)child).addValue(text);
        } else {
            processor.addChild(new TextProcessor(text));
        }
    }

    protected TextProcessor getPreviousChildTextProcessor(TagProcessor processor) {
        TagProcessor child = this.getPreviousChildProcessor(processor);
        if (child instanceof TextProcessor) {
            return (TextProcessor)child;
        }
        return null;
    }

    protected TagProcessor getPreviousChildProcessor(TagProcessor processor) {
        if (processor.getChildCount() > 0) {
            return processor.getChild(processor.getChildCount() - 1);
        }
        return null;
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        this.popProcessor();
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public void warning(SAXParseException e) throws SAXException {
        System.err.println(e);
    }
}

