/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.validator;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.jsf.util.DoubleValidatorUtil;
import org.seasar.jsf.util.MessageUtil;
import org.seasar.jsf.util.UIComponentUtil;

public class S2DoubleRangeValidator
implements Validator,
StateHolder {
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.MINIMUM";
    public static final String TYPE_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.TYPE";
    private Double minimum = null;
    private Double maximum = null;
    private boolean bTransient = false;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (value == null) {
            return;
        }
        double dvalue = DoubleValidatorUtil.parseDoubleValue(context, component, value);
        if (this.minimum != null && this.maximum != null) {
            if (dvalue < this.minimum || dvalue > this.maximum) {
                Object[] args = new Object[]{this.minimum, this.maximum, UIComponentUtil.getLabel(component)};
                throw new ValidatorException(MessageUtil.getErrorMessage("javax.faces.validator.NOT_IN_RANGE", args));
            }
        } else if (this.minimum != null) {
            if (dvalue < this.minimum) {
                Object[] args = new Object[]{this.minimum, UIComponentUtil.getLabel(component)};
                throw new ValidatorException(MessageUtil.getErrorMessage(MINIMUM_MESSAGE_ID, args));
            }
        } else if (this.maximum != null && dvalue > this.maximum) {
            Object[] args = new Object[]{this.maximum, UIComponentUtil.getLabel(component)};
            throw new ValidatorException(MessageUtil.getErrorMessage(MAXIMUM_MESSAGE_ID, args));
        }
    }

    public double getMaximum() {
        return this.maximum != null ? this.maximum : Double.MAX_VALUE;
    }

    public void setMaximum(double maximum) {
        this.maximum = new Double(maximum);
    }

    public double getMinimum() {
        return this.minimum != null ? this.minimum : Double.MIN_VALUE;
    }

    public void setMinimum(double minimum) {
        this.minimum = new Double(minimum);
    }

    public boolean isTransient() {
        return this.bTransient;
    }

    public void setTransient(boolean transientValue) {
        this.bTransient = transientValue;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.maximum, this.minimum};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.maximum = (Double)values[0];
        this.minimum = (Double)values[1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof S2DoubleRangeValidator)) {
            return false;
        }
        S2DoubleRangeValidator doubleRangeValidator = (S2DoubleRangeValidator)o;
        if (this.maximum != null ? !this.maximum.equals(doubleRangeValidator.maximum) : doubleRangeValidator.maximum != null) {
            return false;
        }
        return !(this.minimum != null ? !this.minimum.equals(doubleRangeValidator.minimum) : doubleRangeValidator.minimum != null);
    }
}

