/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.util;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import org.seasar.framework.log.Logger;
import org.seasar.jsf.util.MessageUtil;
import org.seasar.jsf.util.UIComponentUtil;

public final class RenderUtil {
    private static Logger logger = Logger.getLogger(RenderUtil.class);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private RenderUtil() {
    }

    public static void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        Iterator i = component.getChildren().iterator();
        while (i.hasNext()) {
            RenderUtil.encodeChild(context, (UIComponent)i.next());
            if (context.getResponseComplete()) break;
        }
    }

    public static void encodeChild(FacesContext context, UIComponent component) throws IOException {
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            RenderUtil.encodeChildren(context, component);
        }
        component.encodeEnd(context);
    }

    public static boolean renderAttributes(ResponseWriter writer, UIComponent component, String[] attributeNames) throws IOException {
        boolean somethingDone = false;
        int i = 0;
        int len = attributeNames.length;
        while (i < len) {
            String attrName = attributeNames[i];
            if (RenderUtil.renderAttribute(writer, component, attrName)) {
                somethingDone = true;
            }
            ++i;
        }
        return somethingDone;
    }

    public static boolean renderAttribute(ResponseWriter writer, UIComponent component, String attributeName) throws IOException {
        Object value = component.getAttributes().get(attributeName);
        return RenderUtil.renderAttribute(writer, attributeName, value, attributeName);
    }

    public static boolean renderAttribute(ResponseWriter writer, String attributeName, Object value, String propertyName) throws IOException {
        if (value == null) {
            return false;
        }
        if (attributeName.equalsIgnoreCase("styleClass")) {
            attributeName = "class";
        }
        writer.writeAttribute(attributeName, value, propertyName);
        return true;
    }

    public static void renderIdIfNecessary(ResponseWriter writer, UIComponent component, FacesContext context) throws IOException {
        String id = component.getId();
        if (id != null && !id.startsWith("_id")) {
            writer.writeAttribute("id", (Object)component.getClientId(context), null);
        }
    }

    public static Object getConvertedUIOutputValue(FacesContext context, UIOutput output, Object submittedValue) throws ConverterException {
        Converter converter;
        if (submittedValue == null) {
            return null;
        }
        if (!(submittedValue instanceof String)) {
            submittedValue = submittedValue.toString();
        }
        if ((converter = RenderUtil.findConverterForSubmittedValue(context, output)) == null) {
            return submittedValue;
        }
        return converter.getAsObject(context, (UIComponent)output, (String)submittedValue);
    }

    public static Converter findConverterForSubmittedValue(FacesContext context, UIOutput component) {
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueBinding vb = component.getValueBinding("value");
        if (vb == null) {
            return null;
        }
        Class valueType = vb.getType(context);
        if (valueType == null) {
            return null;
        }
        if (String.class.equals((Object)valueType) || Object.class.equals((Object)valueType)) {
            return null;
        }
        try {
            return context.getApplication().createConverter(valueType);
        }
        catch (FacesException ex) {
            logger.log((Throwable)ex);
            return null;
        }
    }

    public static Renderer getRenderer(FacesContext context, UIComponent component) {
        String rendererType = component.getRendererType();
        if (rendererType == null) {
            return null;
        }
        String renderKitId = context.getViewRoot().getRenderKitId();
        RenderKitFactory rkf = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = rkf.getRenderKit(context, renderKitId);
        return renderKit.getRenderer(component.getFamily(), rendererType);
    }

    public static Object getConvertedValue(FacesContext context, UIInput component, Object submittedValue) {
        try {
            Renderer renderer = RenderUtil.getRenderer(context, (UIComponent)component);
            if (renderer != null) {
                return renderer.getConvertedValue(context, (UIComponent)component, submittedValue);
            }
            if (submittedValue instanceof String) {
                return RenderUtil.getConvertedUIOutputValue(context, (UIOutput)component, submittedValue);
            }
        }
        catch (ConverterException e) {
            FacesMessage facesMessage = e.getFacesMessage();
            if (facesMessage != null) {
                context.addMessage(component.getClientId(context), facesMessage);
            } else {
                context.addMessage(component.getClientId(context), MessageUtil.getErrorMessage("javax.faces.component.UIInput.CONVERSION", new Object[]{UIComponentUtil.getLabel((UIComponent)component)}));
            }
            component.setValid(false);
        }
        return submittedValue;
    }
}

