package org.seasar.jsf.render.html;

import java.util.Map;

import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;

import org.seasar.jsf.exception.NoEditableValueHolderRuntimeException;
import org.seasar.jsf.util.RenderUtil;

/**
 * @author higa
 *  
 */
public class HtmlSelectOneRadioRenderer extends Renderer {

    public void decode(FacesContext context, UIComponent component) {
        if (!(component instanceof EditableValueHolder)) {
            throw new NoEditableValueHolderRuntimeException(component
                    .getClass());
        }
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String clientId = component.getClientId(context);
        if (paramMap.containsKey(clientId)) {
            String submittedValue = (String) paramMap.get(clientId);
            if ("on".equalsIgnoreCase(submittedValue)) {
                submittedValue = "";
            }
            ((EditableValueHolder) component).setSubmittedValue(submittedValue);
        } else {
            ((EditableValueHolder) component).setSubmittedValue("");
        }
    }

    public Object getConvertedValue(FacesContext context,
            UIComponent component, Object submittedValue)
            throws ConverterException {
        
        return RenderUtil.getConvertedUIOutputValue(context, (UIOutput) component, submittedValue);
    }
}