package org.seasar.jsf.runtime;

import java.io.InputStream;

import javax.xml.parsers.SAXParser;

import org.seasar.framework.util.SAXParserFactoryUtil;
import org.seasar.framework.xml.SaxHandler;
import org.seasar.framework.xml.SaxHandlerParser;
import org.seasar.jsf.TaglibConfig;

/**
 * @author higa
 *
 */
public final class TaglibConfigBuilder {

	public static final String PUBLIC_ID_11 = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN";
	public static final String PUBLIC_ID_12 = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN";
	public static final String DTD_PATH_11 =
		"org/seasar/jsf/runtime/web-jsptaglibrary_1_1.dtd";
	public static final String DTD_PATH_12 =
		"org/seasar/jsf/runtime/web-jsptaglibrary_1_2.dtd";
	private static TaglibTagHandlerRule rule =
		new TaglibTagHandlerRule();

	public TaglibConfig build(InputStream is) {
		SaxHandlerParser parser = createSaxHandlerParser();
		return (TaglibConfig) parser.parse(is);
	}
	
	private SaxHandlerParser createSaxHandlerParser() {
		SAXParser saxParser = SAXParserFactoryUtil.newSAXParser();
		SaxHandler handler = new SaxHandler(rule);
		handler.registerDtdPath(PUBLIC_ID_11, DTD_PATH_11);
		handler.registerDtdPath(PUBLIC_ID_12, DTD_PATH_12);
		return new SaxHandlerParser(handler, saxParser);
	}
}
