package org.seasar.jsf.selector;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.processor.InputTextareaProcessor;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class InputTextareaSelector extends AbstractTagSelector {

	private static final String TAG_NAME = "inputTextarea";
	
	public InputTextareaSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		return JsfConstants.TEXTAREA_ELEM.equalsIgnoreCase(qName);
	}

	public TagProcessor createProcessor() {
		return new InputTextareaProcessor(getInject());
	}
	
	public String getInject() {
		return getS2JsfInject(TAG_NAME);
	}
}