package org.seasar.jsf.taglib.html;

import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputTextarea;

import org.seasar.jsf.JsfConstants;

public class HtmlInputTextareaTag extends HtmlInputTagBase {

    private String cols;

    private String rows;

    public String getComponentType() {
        return HtmlInputTextarea.COMPONENT_TYPE;
    }

    public String getRendererType() {
        return "javax.faces.Textarea";
    }

    public void setCols(String cols) {
        this.cols = cols;
    }

    public void setRows(String rows) {
        this.rows = rows;
    }

    public void release() {
        super.release();
        cols = null;
        rows = null;
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        setComponentProperty(component, JsfConstants.COLS_ATTR, cols);
        setComponentProperty(component, JsfConstants.ROWS_ATTR, rows);
    }
}