/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.lang.reflect.Constructor;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ClassUnmatchRuntimeException;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.ConstructorAssembler;
import org.seasar.framework.container.IllegalConstructorRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.assembler.AbstractAssembler;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ConstructorUtil;
import org.seasar.framework.util.OgnlUtil;

public abstract class AbstractConstructorAssembler
extends AbstractAssembler
implements ConstructorAssembler {
    public AbstractConstructorAssembler(ComponentDef componentDef) {
        super(componentDef);
    }

    public Object assemble() {
        if (this.getComponentDef().getExpression() != null) {
            return this.assembleExpression();
        }
        if (this.getComponentDef().getArgDefSize() > 0) {
            return this.assembleManual();
        }
        return this.doAssemble();
    }

    protected abstract Object doAssemble();

    protected Object assembleExpression() {
        ComponentDef cd = this.getComponentDef();
        S2Container container = cd.getContainer();
        String expression = cd.getExpression();
        Class componentClass = cd.getComponentClass();
        Object component = null;
        Object exp = OgnlUtil.parseExpression(expression);
        component = OgnlUtil.getValue(exp, container);
        if (componentClass != null && !componentClass.isInstance(component)) {
            throw new ClassUnmatchRuntimeException(componentClass, component != null ? component.getClass() : null);
        }
        return component;
    }

    protected Object assembleManual() {
        Object[] args = new Object[this.getComponentDef().getArgDefSize()];
        int i = 0;
        while (i < args.length) {
            try {
                args[i] = this.getComponentDef().getArgDef(i).getValue();
            }
            catch (ComponentNotFoundRuntimeException cause) {
                throw new IllegalConstructorRuntimeException(this.getComponentDef().getComponentClass(), (Throwable)cause);
            }
            ++i;
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(this.getComponentDef().getConcreteClass());
        return beanDesc.newInstance(args);
    }

    protected Object assembleDefault() {
        Class clazz = this.getComponentDef().getConcreteClass();
        Constructor constructor = ClassUtil.getConstructor(clazz, null);
        return ConstructorUtil.newInstance(constructor, null);
    }
}

