/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.util;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ContainerConstants;

public final class BindingUtil
implements ContainerConstants {
    private BindingUtil() {
    }

    public static final boolean isAutoBindable(Class clazz) {
        return clazz.isInterface();
    }

    public static final boolean isAutoBindable(Class[] classes) {
        int i = 0;
        while (i < classes.length) {
            if (!BindingUtil.isAutoBindable(classes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static BeanDesc getBeanDesc(ComponentDef componentDef, Object component) {
        return BeanDescFactory.getBeanDesc(BindingUtil.getComponentClass(componentDef, component));
    }

    public static Class getComponentClass(ComponentDef componentDef, Object component) {
        Class clazz = componentDef.getComponentClass();
        if (clazz != null) {
            return clazz;
        }
        return component.getClass();
    }
}

