/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.util;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;

public class Traversal {
    public static Object forEachContainer(S2Container container, S2ContainerHandler handler) {
        return Traversal.forEachContainer(container, handler, true);
    }

    public static Object forEachContainer(S2Container container, S2ContainerHandler handler, boolean parentFirst) {
        Object result;
        if (parentFirst && (result = handler.processContainer(container)) != null) {
            return result;
        }
        int i = 0;
        while (i < container.getChildSize()) {
            Object result2 = Traversal.forEachContainer(container.getChild(i), handler, parentFirst);
            if (result2 != null) {
                return result2;
            }
            ++i;
        }
        if (!parentFirst) {
            return handler.processContainer(container);
        }
        return null;
    }

    public static Object forEachComponent(S2Container container, ComponentDefHandler handler) {
        return Traversal.forEachComponent(container, handler, true);
    }

    public static Object forEachComponent(S2Container container, final ComponentDefHandler handler, boolean parentFirst) {
        return Traversal.forEachContainer(container, new S2ContainerHandler(){

            public Object processContainer(S2Container container) {
                int i = 0;
                while (i < container.getComponentDefSize()) {
                    Object result = handler.processComponent(container.getComponentDef(i));
                    if (result != null) {
                        return result;
                    }
                    ++i;
                }
                return null;
            }
        }, parentFirst);
    }

    public static interface S2ContainerHandler {
        public Object processContainer(S2Container var1);
    }

    public static interface ComponentDefHandler {
        public Object processComponent(ComponentDef var1);
    }
}

