/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.BeanValidatorForm;
import org.seasar.struts.util.BeanValidatorFormUtil;

public class ActionFormUtil {
    private ActionFormUtil() {
    }

    public static Object getActualForm(HttpServletRequest request, ActionMapping mapping) {
        ActionForm form = ActionFormUtil.getActionForm(request, mapping);
        return BeanValidatorFormUtil.toBean(form);
    }

    public static void setActualForm(HttpServletRequest request, Object form, ActionMapping mapping) {
        if (form instanceof ActionForm) {
            ActionFormUtil.setActionForm(request, form, mapping);
        } else {
            BeanValidatorForm oldForm = (BeanValidatorForm)ActionFormUtil.getActionForm(request, mapping);
            Object newForm = BeanValidatorFormUtil.toBeanValidatorForm(oldForm, form);
            ActionFormUtil.setActionForm(request, newForm, mapping);
        }
    }

    private static ActionForm getActionForm(HttpServletRequest request, ActionMapping mapping) {
        if ("request".equals(mapping.getScope())) {
            return (ActionForm)request.getAttribute(mapping.getAttribute());
        }
        HttpSession session = request.getSession();
        return (ActionForm)session.getAttribute(mapping.getAttribute());
    }

    private static void setActionForm(HttpServletRequest request, Object form, ActionMapping mapping) {
        if (form == null) {
            return;
        }
        String scope = mapping.getScope();
        if ("request".equals(scope)) {
            request.setAttribute(mapping.getAttribute(), form);
        } else {
            HttpSession session = request.getSession();
            session.setAttribute(mapping.getAttribute(), form);
        }
    }
}

