package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class IsNullExp implements BooleanExpression {

    private final Expression _targetExp;

    public IsNullExp(final Expression targetExp) {
    	Assertion.assertNotNull("targetExp", targetExp);

        _targetExp = targetExp;
    }

    public boolean evaluate(RuleContext ruleContext) throws SeasarException {
        Object target = _targetExp.evaluateValue(ruleContext);
        if (target == null) {
            return true;
        } else {
            return false;
        }
    }
}