package examples.org.seasar.mbean;

import java.io.IOException;

import javax.management.Notification;

import org.seasar.mbean.NotifyListenerSupport;
import org.seasar.mbean.RemoteNotificationListenerFacade;


public class HelloNotifyListener extends NotifyListenerSupport {

	public void receive(Notification notification) {
		System.out.println(notification.getUserData());
	}
	
	public static void main(String[] args) {
		RemoteNotificationListenerFacade rnlf =
			new RemoteNotificationListenerFacade(
				HelloNotifyListener.class.getName(),
				"HelloNotify", "seasar");
		rnlf.start();
		try {
			System.in.read();
		} catch (IOException ex) {
			ex.printStackTrace();
		} finally {
			rnlf.stop();
		}
	}

}
