package org.seasar.nazuna;



public final class BooleanExp implements BooleanExpression, Expression {

    private final boolean _value;

    public BooleanExp(boolean value) {
        _value = value;
    }

    public boolean evaluate(RuleContext ruleContext) {
        return _value;
    }
    
    public Object evaluateValue(RuleContext ruleContext) {
        return _value ? Boolean.TRUE : Boolean.FALSE;
    }
}