package org.seasar.nazuna;

import java.util.List;
import java.util.Map;

import org.seasar.util.ArrayUtil;
import org.seasar.util.ResourceUtil;
import org.seasar.util.SeasarException;

public final class Nazuna {

	public static final String CONFIG_FILE_PATH = "/nazuna-config.xml";
    private static NazunaConfig _nazunaConfig;
    
    static {
    	configure();
    }

    private Nazuna() {
    }
    
    public static final Object executeRulet(String className)
			throws SeasarException {
				
		return executeRulet(className, ArrayUtil.EMPTY_OBJECTS);
	}
	
	public static final Object executeRulet(String className,
			Object arg0) throws SeasarException {
				
		return executeRulet(className, new Object[]{arg0});
	}
	
	public static final Object executeRulet(String className,
			Object arg0, Object arg1) throws SeasarException {
				
		return executeRulet(className, new Object[]{arg0, arg1});
	}
	
	public static final Object executeRulet(String className,
			Object arg0, Object arg1, Object arg2) throws SeasarException {
				
		return executeRulet(className, new Object[]{arg0, arg1, arg2});
	}
	
	public static final Object executeRulet(String className,
			Object arg0, Object arg1, Object arg2, Object arg3)
			throws SeasarException {
				
		return executeRulet(className, new Object[]{arg0, arg1, arg2, arg3});
	}
	
	public static final Object executeRulet(String className,
			Object arg0, Object arg1, Object arg2, Object arg3, Object arg4)
			throws SeasarException {
				
		return executeRulet(className, new Object[]{arg0, arg1, arg2, arg3, arg4});
	}
	
	public static final Object executeRulet(String className, Object[] args)
			throws SeasarException {
				
		if (args == null) {
			args = ArrayUtil.EMPTY_OBJECTS;
		}
		RuletFacade facade = RuletContainer.getRuletFacade(className);
		return facade.execute(args);
	}
    
    public static Object execute(final String name) throws SeasarException {
    	Flowlet flowlet = FlowletContainer.getFlowlet(name);
    	return flowlet.execute();
    }
    
    public static Object execute(final String name, final Map parameters)
    		throws SeasarException {
    			
    	Flowlet flowlet = FlowletContainer.getFlowlet(name);
    	return flowlet.execute(parameters);
    }
    
    public static List executeQuery(final String name) throws SeasarException {
    	Sqlet sqlet = SqletContainer.getSqlet(name);
    	return sqlet.executeQuery();
    }
    
    public static List executeQuery(final String name, final Map parameters)
    		throws SeasarException {
    			
    	Sqlet sqlet = SqletContainer.getSqlet(name);
    	return sqlet.executeQuery(parameters);
    }
    
	public static NzRecordSet executeRSQuery(final String name) throws SeasarException {
		Sqlet sqlet = SqletContainer.getSqlet(name);
		return sqlet.executeRSQuery();
	}

	public static NzRecordSet executeRSQuery(final String name, final Map parameters)
			throws SeasarException {
			
		Sqlet sqlet = SqletContainer.getSqlet(name);
		return sqlet.executeRSQuery(parameters);
	}
    
    public static int executeUpdate(final String name) throws SeasarException {
    	Sqlet sqlet = SqletContainer.getSqlet(name);
    	return sqlet.executeUpdate();
    }
    
    public static int executeUpdate(final String name, final Map parameters)
    		throws SeasarException {
    			
    	Sqlet sqlet = SqletContainer.getSqlet(name);
    	return sqlet.executeUpdate(parameters);
    }
    
    public static NazunaConfig getNazunaConfig() {
    	return _nazunaConfig;
    }
    
    private static void configure() {
    	if (ResourceUtil.isExist(CONFIG_FILE_PATH)) {
    		_nazunaConfig = NazunaConfigBuilder.parse(CONFIG_FILE_PATH);
    	}
    }
}