package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class OrExp implements BooleanExpression {

    private final BooleanExpression _arg1Exp;
    private final BooleanExpression _arg2Exp;

    public OrExp(final BooleanExpression arg1Exp, final BooleanExpression arg2Exp) {
    	Assertion.assertNotNull("arg1Exp", arg1Exp);
    	Assertion.assertNotNull("arg2Exp", arg2Exp);

        _arg1Exp = arg1Exp;
        _arg2Exp = arg2Exp;
    }

    public boolean evaluate(final RuleContext ruleContext) throws SeasarException {
    	if (_arg1Exp.evaluate(ruleContext)) {
    		return true;
    	} else {
        	return _arg2Exp.evaluate(ruleContext);
    	}
    }
}