package org.seasar.sql;

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public final class DataSourceFactory implements ObjectFactory {

    public DataSourceFactory() {
    }

    public Object getObjectInstance(final Object refObj, final Name name,
            final Context ctx, Hashtable env) throws Exception {

        Reference ref = (Reference)refObj;
        DataSourceImpl ds = new DataSourceImpl();
        String dsname = (String)ref.get("dataSourceName").getContent();
        ds.setDataSourceName(dsname);
        if (!ConnectionPoolManager.getInstance().hasConnectionPoolMetaData(dsname)) {
	        ConnectionPoolMetaData cpmd = (ConnectionPoolMetaData) ctx.lookup(
	                "connectionPoolMetaData/" + dsname);
	        ConnectionPoolManager.getInstance().registerConnectionPoolMetaData(cpmd);
        }
        return ds;
    }
}