package test.org.seasar.nazuna;

import java.math.BigDecimal;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.Expression;
import org.seasar.nazuna.NewExp;
import org.seasar.nazuna.StringExp;

public class NewExpTest extends TestCase {

    public NewExpTest(String name) {
        super(name);
    }
    
    public void testEvaluateValue() throws Exception {
    	Expression exp = new NewExp(BigDecimal.class,
    		new Expression[]{new StringExp("1")});
        assertEquals("1", new BigDecimal("1"), exp.evaluateValue(null));
    }
    
    public void testEvaluateValue2() throws Exception {
    	Expression exp = new NewExp(Object.class, Expression.EMPTY_EXPRESSIONS);
        assertNotNull("1", exp.evaluateValue(null));
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(NewExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{NewExpTest.class.getName()});
    }
}