package org.seasar.nazuna;

import java.lang.reflect.Method;
import java.sql.ResultSet;

import org.seasar.util.Assertion;
import org.seasar.util.Reflector;
import org.seasar.util.SeasarException;

public final class BeanPropertyType extends PropertyType {

	private Method _setterMethod;
	
	public BeanPropertyType(
		String name,
		String columnName,
		ValueType valueType,
		Method setterMethod) {

		super(name, columnName, valueType);
		Assertion.assertNotNull("setterMethod", setterMethod);
		
		_setterMethod = setterMethod;
	}

	public void fetch(ResultSet rs, Object target) throws SeasarException {
		Object value = _valueType.getValue(rs, _columnName);
		Reflector.invoke(_setterMethod, target, new Object[]{value});
		
	}
}
