package org.seasar.nazuna;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class FilterDesc {

	private BooleanExpression _conditionExp;
	
	public FilterDesc(String condition) throws SeasarException {
		_conditionExp = new RuleParser(condition).parseBooleanExpression();
	}

	public List filter(List items) throws SeasarException {
		return filter(items, null);
	}
	
	public List filter(List items, Map parameters) throws SeasarException {
		Assertion.assertNotNull("items", items);
		
		List ret = new ArrayList();
		FilterRuleContext ruleContext = new FilterRuleContext(parameters);
		for (int i = 0; i < items.size(); ++i) {
			Object item = items.get(i);
			ruleContext.setItem(item);
			if (_conditionExp.evaluate(ruleContext)) {
				ret.add(item);
			}
		}
		return ret;
	}
	
	public Object filterFirst(List items) throws SeasarException {
		return filterFirst(items, null);
	}
	
	public Object filterFirst(List items, Map parameters) throws SeasarException {
		Assertion.assertNotNull("items", items);
		
		FilterRuleContext ruleContext = new FilterRuleContext(parameters);
		for (int i = 0; i < items.size(); ++i) {
			Object item = items.get(i);
			ruleContext.setItem(item);
			if (_conditionExp.evaluate(ruleContext)) {
				return item;
			}
		}
		return null;
	}
}
