package org.seasar.nazuna.amf;

import java.util.List;
import javax.servlet.http.HttpServletRequest;

import org.seasar.nazuna.Nazuna;
import org.seasar.util.ArrayUtil;
import org.seasar.util.SeasarException;

public final class AMFBody {

	private String _target;
	private String _serviceName;
	private String _serviceMethodName;
	private String _response;
	private Object _value;

	public AMFBody(String target, String response, Object value) {
		_target = target;
		_response = response;
		_value = value;
		int dotIndex = target.lastIndexOf('.');
		if (dotIndex > 0) {
			_serviceName = target.substring(0, dotIndex);
			_serviceMethodName = target.substring(dotIndex + 1);
		}
	}

	public final String getTarget() {
		return _target;
	}

	public final String getServiceName() {
		return _serviceName;
	}

	public final String getServiceMethodName() {
		return _serviceMethodName;
	}

	public final String getResponse() {
		return _response;
	}

	public final Object getValue() {
		return _value;
	}

	public final Object invoke(HttpServletRequest request)
		throws SeasarException {

		Object[] args = convertArgs();
		if ("execute".equalsIgnoreCase(_serviceMethodName)) {
			return Nazuna.execute(_serviceName, args);
		} else if ("executeRSQuery".equalsIgnoreCase(_serviceMethodName)) {
			return Nazuna.executeRSQuery(_serviceName, args);
		} else if ("executeQuery".equalsIgnoreCase(_serviceMethodName)) {
			return Nazuna.executeQuery(_serviceName, args);
		} else if ("executeUpdate".equalsIgnoreCase(_serviceMethodName)) {
			return new Integer(Nazuna.executeUpdate(_serviceName, args));
		} else if ("executeSingleQuery".equalsIgnoreCase(_serviceMethodName)) {
			return Nazuna.executeSingleQuery(_serviceName, args);
		} else if ("executeRulet".equalsIgnoreCase(_serviceMethodName)) {
			return Nazuna.executeRulet(_serviceName, args);
		}
		throw new SeasarException("ESSR0001", _serviceMethodName);
	}

	public final Object[] convertArgs() {
		if (_value != null && _value instanceof List) {
			return ((List) _value).toArray();
		}
		return ArrayUtil.EMPTY_OBJECTS;
	}

	public final String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("target=");
		buf.append(_target);
		buf.append(",response=");
		buf.append(_response);
		buf.append(",value=");
		buf.append(_value);
		return buf.toString();
	}

}