package org.seasar.timer;

import org.seasar.util.SeasarRuntimeException;

public class TimeoutTask {

    private final static int ACTIVE = 0;
    private final static int STOPPED = 1;
    private final static int CANCELED = 2;

    private final TimeoutTarget _timeoutTarget;
    private final long _timeoutMillis;
    private final boolean _permanent;
    private long _startTime;
    private int _status = ACTIVE;

    TimeoutTask(final TimeoutTarget timeoutTarget, final int timeout,
            final boolean permanent) {

        _timeoutTarget = timeoutTarget;
        _timeoutMillis = timeout * 1000;
        _permanent = permanent;
        _startTime = System.currentTimeMillis();
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= _startTime + _timeoutMillis;
    }

    public boolean isPermanent() {
        return _permanent;
    }

    public boolean isCanceled() {
        return _status == CANCELED;
    }

    public void cancel() {
        _status = CANCELED;
    }

    public boolean isStopped() {
        return _status == STOPPED;
    }

    public void stop() {
        if (_status != ACTIVE) {
            throw new SeasarRuntimeException("ECHR0024");
        }
        _status = STOPPED;
    }

    public void restart() {
        _status = ACTIVE;
        _startTime = System.currentTimeMillis();
    }

    void expired() {
        _timeoutTarget.expired();
    }
}
