package test.org.seasar.mbean;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.mbean.MBeanFacade;
import org.seasar.mbean.MBeanService;
import org.seasar.mbean.NotificationListenerFacade;
import org.seasar.mbean.RemoteNotificationListenerFacade;
import org.seasar.system.JMXUtil;
import org.seasar.util.SeasarContext;

import test.org.seasar.system.HelloMBean;
import test.org.seasar.system.NotificationListenerTester;
import test.org.seasar.system.NotifyMBean;

public class MBeanServiceTest extends MBeanTestCase {
	
    public MBeanServiceTest(String name) throws Exception {
        super(name);
    }

	public void testMBeanContainer() throws Exception {
		SeasarContext ctx = SeasarContext.getInstance();
    	HelloMBean hello = (HelloMBean) ctx.lookupNoCache(JMXUtil.getJNDIName("Hello"));
    	assertNotNull("1", hello);
    	assertEquals("2", "hello", hello.greeting());
    	
    	HelloMBean hello2 = (HelloMBean) ctx.lookupNoCache(JMXUtil.getJNDIName("Hello2"));
    	assertNotNull("3", hello2);
    	assertEquals("4", "hello2", hello2.greeting());
    	
    	MBeanFacade container = (MBeanFacade) MBeanService.getContainer(1);
	}

	public void testNotificationListenerContainer() throws Exception {
		SeasarContext ctx = SeasarContext.getInstance();
    	NotifyMBean notify = (NotifyMBean) ctx.lookupNoCache(JMXUtil.getJNDIName("Notify"));
    	notify.sendMessage("Hello");
    	NotificationListenerFacade container = (NotificationListenerFacade) MBeanService.getContainer(4);
    	NotificationListenerTester listener = (NotificationListenerTester) container.getNotificationListener();
    	assertEquals("1", true, listener.isCalled());
	}
	
	public void testRemoteNotificationListenerContainer() throws Exception {
		SeasarContext ctx = SeasarContext.getInstance();
    	NotifyMBean notify = (NotifyMBean) ctx.lookupNoCache(JMXUtil.getJNDIName("Notify"));
    	notify.sendMessage("Hello");
    	RemoteNotificationListenerFacade container = (RemoteNotificationListenerFacade) MBeanService.getContainer(5);
    	NotificationListenerTester listener = (NotificationListenerTester) container.getNotificationListener();
    	assertEquals("1", true, listener.isCalled());
	}

    protected void setUp() throws Exception {
    	super.setUp();    	
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(MBeanServiceTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{MBeanServiceTest.class.getName()});
    }
}