package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.AndExp;
import org.seasar.nazuna.BooleanExpression;
import org.seasar.nazuna.EqualExp;
import org.seasar.nazuna.IntegerExp;
import org.seasar.nazuna.NullExp;

public class AndExpTest extends TestCase {

    public AndExpTest(String name) {
        super(name);
    }

    public void testEvaluate() throws Exception {
        IntegerExp iExp = new IntegerExp(new Integer(1));
        BooleanExpression eqExp = new EqualExp(iExp, iExp);
        BooleanExpression exp = new AndExp(eqExp, eqExp);
        assertEquals("1", true, exp.evaluate(null));
    }
    
    public void testEvaluate2() throws Exception {
        IntegerExp iExp = new IntegerExp(new Integer(1));
        BooleanExpression eqExp = new EqualExp(iExp, iExp);
        BooleanExpression eq2Exp = new EqualExp(iExp, new NullExp());
        BooleanExpression exp = new AndExp(eqExp, eq2Exp);
        assertEquals("1", false, exp.evaluate(null));
    }
    
    public void testEvaluate3() throws Exception {
        IntegerExp iExp = new IntegerExp(new Integer(1));
        BooleanExpression eqExp = new EqualExp(iExp, iExp);
        BooleanExpression eq2Exp = new EqualExp(iExp, new NullExp());
        BooleanExpression exp = new AndExp(eq2Exp, eqExp);
        assertEquals("1", false, exp.evaluate(null));
    }
    
    public void testEvaluate4() throws Exception {
        IntegerExp iExp = new IntegerExp(new Integer(1));
        BooleanExpression eqExp = new EqualExp(iExp, new NullExp());
        BooleanExpression exp = new AndExp(eqExp, eqExp);
        assertEquals("1", false, exp.evaluate(null));
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(AndExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{AndExpTest.class.getName()});
    }
}