#include "seasar/lang/SObject.as"
#include "seasar/nazuna/RuleService.as"
#include "seasar/event/Broadcaster.as"

if (seasar.nazuna.RuleEventService === undefined) {
	seasar.lang.SObject.defineClass("seasar.nazuna.RuleEventService", seasar.nazuna.RuleService,
		["resultEvent", "statusEvent"],
		function(connection, ruleName, resultEvent, statusEvent) {
			super(connection, ruleName);
			this.resultEvent = resultEvent;
			this.statusEvent = statusEvent;
		});
	
	var proto = seasar.nazuna.RuleEventService.prototype;
	
	proto.onResult = function (result) {
		seasar.event.Broadcaster.broadcast(this.resultEvent, result);
	}
	
	proto.onStatus = function (result) {
		trace(result.details);
		if (this.statusEvent !== undefined) {
			seasar.event.Broadcaster.broadcast(this.statusEvent, result);
		}
	}

	delete proto;
}