#include "seasar/lang/SObject.as"

if (seasar.nazuna.RuleService === undefined) {
	seasar.lang.SObject.defineClass("seasar.nazuna.RuleService", null,
		["rule", "ruleName"],
		function(connection, ruleName) {
			super();
			this.ruleName = ruleName;
			this.rule = connection.getService(this.ruleName, this);
		});
	
	var proto = seasar.nazuna.RuleService.prototype;
	
	proto.onResult = function(result) {
		trace(result);
	}
	
	proto.onStatus = function(result) {
		trace(result.details);
	}
	
	proto.execute_Result = this.onResult;
	proto.execute_Status = this.onStatus;
	proto.executeQuery_Result = this.onResult;
	proto.executeQuery_Status = this.onStatus;
	proto.executeRSQuery_Result = this.onResult;
	proto.executeRSQuery_Status = this.onStatus;
	proto.executeSingleQuery_Result = this.onResult;
	proto.executeSingleQuery_Status = this.onStatus;
	proto.executeUpdate_Result = this.onResult;
	proto.executeUpdate_Status = this.onStatus;
	proto.executeRulet_Result = this.onResult;
	proto.executeRulet_Status = this.onStatus;
	
	delete proto;
}