package org.seasar.expr;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

abstract class AbstractCompareExp implements BooleanExpression {

	private Expression _arg1Exp;
	private Expression _arg2Exp;

	public AbstractCompareExp(Expression arg1Exp, Expression arg2Exp) {
		Assertion.assertNotNull("arg1Exp", arg1Exp);
		Assertion.assertNotNull("arg2Exp", arg2Exp);

		_arg1Exp = arg1Exp;
		_arg2Exp = arg2Exp;
	}

	protected Comparable getArg1(ExprContext context) throws SeasarException {
		return (Comparable) _arg1Exp.evaluateValue(context);
	}

	protected Comparable getArg2(ExprContext context) throws SeasarException {
		return (Comparable) _arg2Exp.evaluateValue(context);
	}
}
