package org.seasar.expr;

import org.seasar.util.MathUtil;
import org.seasar.util.SeasarException;

public final class AddExp extends AbstractCalculateExp {

	public AddExp(final Expression arg1Exp, final Expression arg2Exp) {
		super(arg1Exp, arg2Exp);
	}

	public Object evaluateValue(ExprContext context) throws SeasarException {
		return MathUtil.add(getArg1(context), getArg2(context));
	}
}