package org.seasar.expr;

import org.seasar.util.Assertion;

public final class AliasConfig {

	private String _name;
	private String _className;
	private String _methodName;

	public AliasConfig(String name, String className, String methodName) {
		Assertion.assertNotNull("name", name);
		Assertion.assertNotNull("className", className);
		Assertion.assertNotNull("methodName", methodName);

		_name = name;
		_className = className;
		_methodName = methodName;
	}

	public String getName() {
		return _name;
	}

	public String getClassName() {
		return _className;
	}

	public String getMethodName() {
		return _methodName;
	}
}
